/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.util.registry.SimpleRegistry;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MappedRegistry<T, U>
extends SimpleRegistry<T> {
    private final Map<T, U> mappings = new Object2ObjectOpenHashMap();
    private final Map<U, T> reverseMappings = new Object2ObjectOpenHashMap();

    MappedRegistry() {
    }

    void registerMapping(T value, U mapping) {
        this.mappings.put(value, mapping);
        this.reverseMappings.put(mapping, value);
    }

    public @Nullable U getMapping(T value) {
        return this.mappings.get(value);
    }

    public U requireMapping(T value) {
        U mapping = this.mappings.get(value);
        if (mapping == null) {
            throw new IllegalArgumentException("Failed to get mapping for: " + value);
        }
        return mapping;
    }

    public @Nullable T getReverseMapping(U value) {
        return this.reverseMappings.get(value);
    }

    public T requireReverseMapping(U value) {
        T mapping = this.reverseMappings.get(value);
        if (mapping == null) {
            throw new IllegalArgumentException("Failed to get reverse mapping for: " + value);
        }
        return mapping;
    }
}

