/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.MerchantOffer;
import org.spongepowered.api.data.type.ProfessionType;
import org.spongepowered.api.item.merchant.Merchant;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;
import org.spongepowered.api.item.merchant.VillagerRegistry;

public final class SpongeVillagerRegistry
implements VillagerRegistry {
    private final Map<ProfessionType, Multimap<Integer, TradeOfferListMutator>> careerGeneratorMap = new HashMap<ProfessionType, Multimap<Integer, TradeOfferListMutator>>();

    public static SpongeVillagerRegistry getInstance() {
        return Holder.INSTANCE;
    }

    SpongeVillagerRegistry() {
    }

    @Override
    public Multimap<Integer, TradeOfferListMutator> getTradeOfferLevelMap(ProfessionType career) {
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!"));
        if (multimap == null) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.copyOf(multimap);
    }

    @Override
    public VillagerRegistry addMutator(ProfessionType career, int level, TradeOfferListMutator generator) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull((Object)generator, (Object)"Generator cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)3);
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.put((Object)level, (Object)generator);
        return this;
    }

    @Override
    public VillagerRegistry addMutators(ProfessionType career, int level, TradeOfferListMutator generator, TradeOfferListMutator ... generators) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull((Object)generator, (Object)"Generator cannot be null!");
        Preconditions.checkNotNull((Object)generators, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(generator);
        for (TradeOfferListMutator element : generators) {
            list.add(Preconditions.checkNotNull((Object)element, (Object)"TradeOfferListMutator cannot be null!"));
        }
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)list.size());
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.putAll((Object)level, list);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(ProfessionType career, int level, List<TradeOfferListMutator> generators) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull(generators, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)generators.size());
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.replaceValues((Object)level, generators);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(ProfessionType career, Multimap<Integer, TradeOfferListMutator> generatorMap) {
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull(generatorMap, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap != null) {
            multimap.clear();
        }
        multimap = ArrayListMultimap.create(generatorMap);
        this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        return this;
    }

    public void populateOffers(Merchant merchant, List<MerchantOffer> currentOffers, VillagerData data, Random random) {
        this.populateOffers(merchant, currentOffers, (ProfessionType)data.getProfession(), data.getLevel(), random);
    }

    private static TradeOfferListMutator generatorFor(VillagerTrades.ITrade iTradeList) {
        return (TradeOfferListMutator)iTradeList;
    }

    static final class Holder {
        static final SpongeVillagerRegistry INSTANCE = new SpongeVillagerRegistry();

        Holder() {
        }
    }
}

