/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.builtin.sponge;

import com.mojang.brigadier.arguments.ArgumentType;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.command.arguments.ScoreHolderArgument;
import net.minecraft.command.arguments.serializers.StringArgumentSerializer;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.registrar.tree.ClientCompletionKey;
import org.spongepowered.common.accessor.command.arguments.ArgumentSerializerAccessor;
import org.spongepowered.common.accessor.command.arguments.ArgumentTypesAccessor;
import org.spongepowered.common.accessor.command.arguments.ArgumentTypes_EntryAccessor;
import org.spongepowered.common.command.registrar.tree.key.SpongeAmountClientCompletionKey;
import org.spongepowered.common.command.registrar.tree.key.SpongeBasicClientCompletionKey;
import org.spongepowered.common.command.registrar.tree.key.SpongeEntityClientCompletionKey;
import org.spongepowered.common.command.registrar.tree.key.SpongeRangeClientCompletionKey;
import org.spongepowered.common.command.registrar.tree.key.SpongeStringClientCompletionKey;

public final class ClientCompletionKeyStreamGenerator {
    private ClientCompletionKeyStreamGenerator() {
    }

    public static Stream<? extends ClientCompletionKey<?>> stream() {
        return ArgumentTypesAccessor.accessor$getID_TYPE_MAP().entrySet().stream().map(ClientCompletionKeyStreamGenerator::transform).filter(Objects::nonNull);
    }

    private static ClientCompletionKey<?> transform(Map.Entry<ResourceLocation, ArgumentTypes_EntryAccessor> entry) {
        ResourceKey key = ResourceKey.sponge(entry.getKey().getPath());
        IArgumentSerializer<?> serializer = entry.getValue().accessor$getSerializer();
        if (serializer instanceof ArgumentSerializerAccessor) {
            return new SpongeBasicClientCompletionKey(key, (ArgumentType)((ArgumentSerializerAccessor)serializer).accessor$getFactory().get());
        }
        if (serializer instanceof EntityArgument.Serializer) {
            return new SpongeEntityClientCompletionKey(key);
        }
        if (serializer instanceof StringArgumentSerializer) {
            return new SpongeStringClientCompletionKey(key);
        }
        if (serializer instanceof ScoreHolderArgument.Serializer) {
            return new SpongeAmountClientCompletionKey(key, (ArgumentType<?>)ScoreHolderArgument.scoreHolder(), (ArgumentType<?>)ScoreHolderArgument.scoreHolders());
        }
        return SpongeRangeClientCompletionKey.createFrom(key, serializer);
    }
}

