/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.builtin.sponge;

import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;

public final class DisplaySlotStreamGenerator {
    private DisplaySlotStreamGenerator() {
    }

    public static Stream<Tuple<DisplaySlot, Integer>> stream() {
        Stream.Builder<Tuple<SpongeDisplaySlot, Integer>> builder = Stream.builder();
        builder.add(new Tuple<SpongeDisplaySlot, Integer>(new SpongeDisplaySlot(ResourceKey.sponge("below_name"), 2), 0));
        builder.add(new Tuple<SpongeDisplaySlot, Integer>(new SpongeDisplaySlot(ResourceKey.sponge("list"), 0), 1));
        HashMap<TextFormatting, SpongeDisplaySlot> sidebarByColor = new HashMap<TextFormatting, SpongeDisplaySlot>();
        Function<TextFormatting, DisplaySlot> sidebarWithColor = sidebarByColor::get;
        sidebarByColor.put(TextFormatting.RESET, new SpongeDisplaySlot(ResourceKey.sponge("sidebar_team_no_color"), 1, null, sidebarWithColor));
        for (TextFormatting formatting : TextFormatting.values()) {
            if (!formatting.isColor() || formatting == TextFormatting.RESET) continue;
            sidebarByColor.put(formatting, new SpongeDisplaySlot(ResourceKey.sponge("sidebar_team_" + formatting.getFriendlyName()), 3 + formatting.getColorIndex(), formatting, sidebarWithColor));
        }
        sidebarByColor.values().forEach(slot -> builder.add(new Tuple<SpongeDisplaySlot, Integer>((SpongeDisplaySlot)slot, slot.getIndex())));
        return builder.build();
    }
}

