/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DaylightDetectorBlock;
import net.minecraft.block.DetectorRailBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.TripWireHookBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WeightedPressurePlateBlock;
import net.minecraft.state.IProperty;
import org.apache.logging.log4j.LogManager;

public class BlockPropertyIdProvider {
    private final IdentityHashMap<IProperty<?>, String> propertyIdMap = new IdentityHashMap();
    private final HashMap<String, IProperty<?>> idPropertyMap = new HashMap();

    public static BlockPropertyIdProvider getInstance() {
        return Holder.INSTANCE;
    }

    public static String getIdFor(IProperty<?> iProperty) {
        return BlockPropertyIdProvider.getInstance().propertyIdMap.get(iProperty);
    }

    public Optional<String> get(IProperty<?> key) {
        return Optional.ofNullable(this.propertyIdMap.get(Preconditions.checkNotNull(key, (Object)"Property cannot be null!")));
    }

    public Optional<IProperty<?>> getKey(String value) {
        return Optional.ofNullable(this.idPropertyMap.get(((String)Preconditions.checkNotNull((Object)value, (Object)"Id cannot be null!")).toLowerCase(Locale.ENGLISH)));
    }

    private boolean isRegistered(IProperty<?> property) {
        return this.propertyIdMap.containsKey(property);
    }

    public static String getIdAndTryRegistration(IProperty<?> property, Block block, String blockId) {
        BlockPropertyIdProvider instance = BlockPropertyIdProvider.getInstance();
        Preconditions.checkNotNull(property, (Object)"Property is null! Cannot retrieve a registration for a null property!");
        Preconditions.checkNotNull((Object)block, (Object)"Block cannot be null!");
        Preconditions.checkNotNull((Object)blockId, (Object)"Block id cannot be null!");
        Preconditions.checkArgument((!blockId.isEmpty() ? 1 : 0) != 0, (Object)"Block id cannot be empty!");
        if (instance.isRegistered(property)) {
            return instance.propertyIdMap.get(property);
        }
        String lowerCasedBlockId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, blockId);
        String modId = lowerCasedBlockId.split(":")[0];
        String propertyName = property.getName();
        String lastAttemptId = lowerCasedBlockId + "_" + property.getName();
        try {
            String originalClass = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, block.getClass().getSimpleName());
            Class<?> blockClass = block.getClass();
            while (true) {
                if (blockClass == Object.class) {
                    String propertyId = modId + ":" + originalClass + "_" + property.getName();
                    LogManager.getLogger("Sponge").warn("Could not find {} owning class, assigning fallback id: {}", (Object)property.getName(), (Object)propertyId);
                    instance.register(property, propertyId);
                    return propertyId;
                }
                for (Field field : blockClass.getDeclaredFields()) {
                    Object o;
                    field.setAccessible(true);
                    boolean isStatic = Modifier.isStatic(field.getModifiers());
                    Object object = o = isStatic ? field.get(null) : field.get(block);
                    if (property != o) continue;
                    String className = field.getDeclaringClass().getSimpleName().replace("Block", "").replace("block", "");
                    String classNameId = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className);
                    String propertyClassName = isStatic ? classNameId : originalClass;
                    String combinedId = modId + ":" + propertyClassName + "_" + propertyName.toLowerCase(Locale.ENGLISH);
                    if (instance.idPropertyMap.containsKey(combinedId)) {
                        if (instance.idPropertyMap.containsKey(lastAttemptId)) {
                            throw new IllegalArgumentException("Sorry! Someone is trying to re-register a block with the same property instances ofblock: " + blockId + " , with property: " + propertyName);
                        }
                        instance.register((IProperty)o, lastAttemptId);
                        return lastAttemptId;
                    }
                    instance.register((IProperty)o, combinedId);
                    return combinedId;
                }
                blockClass = blockClass.getSuperclass();
            }
        }
        catch (Exception e) {
            LogManager.getLogger("Sponge").warn("An exception was thrown while trying to resolve the property " + property.getName() + "'s owning class, assigning fallback id: " + lastAttemptId, (Throwable)e);
            instance.register(property, lastAttemptId);
            return lastAttemptId;
        }
    }

    private void register(IProperty<?> property, String id) {
        Preconditions.checkArgument((!this.propertyIdMap.containsKey(property) ? 1 : 0) != 0, (Object)("Property is already registered! Property: " + property.getName() + " is registered as : " + this.propertyIdMap.get(property)));
        this.propertyIdMap.put(property, id.toLowerCase(Locale.ENGLISH));
        this.idPropertyMap.put(id.toLowerCase(Locale.ENGLISH), property);
    }

    BlockPropertyIdProvider() {
        this.register((IProperty<?>)HorizontalBlock.HORIZONTAL_FACING, "minecraft:horizontal_facing");
        this.register((IProperty<?>)RotatedPillarBlock.AXIS, "minecraft:pillar_axis");
        this.register((IProperty<?>)DirectionalBlock.FACING, "minecraft:directional_facing");
        this.register((IProperty<?>)FarmlandBlock.MOISTURE, "minecraft:farmland_moisture");
        this.register((IProperty<?>)PistonBlock.EXTENDED, "minecraft:piston_extended");
        this.register((IProperty<?>)VineBlock.NORTH, "minecraft:vine_north");
        this.register((IProperty<?>)VineBlock.EAST, "minecraft:vine_east");
        this.register((IProperty<?>)VineBlock.SOUTH, "minecraft:vine_south");
        this.register((IProperty<?>)VineBlock.WEST, "minecraft:vine_west");
        this.register((IProperty<?>)VineBlock.UP, "minecraft:vine_up");
        this.register((IProperty<?>)SugarCaneBlock.AGE, "minecraft:reed_age");
        this.register((IProperty<?>)MyceliumBlock.SNOWY, "minecraft:mycelium_snowy");
        this.register((IProperty<?>)EndPortalFrameBlock.EYE, "minecraft:end_portal_eye");
        this.register((IProperty<?>)SnowBlock.LAYERS, "minecraft:snow_layer");
        this.register((IProperty<?>)WallBlock.UP, "minecraft:wall_up");
        this.register((IProperty<?>)WallBlock.NORTH, "minecraft:wall_north");
        this.register((IProperty<?>)WallBlock.EAST, "minecraft:wall_east");
        this.register((IProperty<?>)WallBlock.SOUTH, "minecraft:wall_south");
        this.register((IProperty<?>)WallBlock.WEST, "minecraft:wall_west");
        this.register((IProperty<?>)StairsBlock.HALF, "minecraft:stairs_half");
        this.register((IProperty<?>)StairsBlock.SHAPE, "minecraft:stairs_shape");
        this.register((IProperty<?>)AbstractButtonBlock.POWERED, "minecraft:button_powered");
        this.register((IProperty<?>)CactusBlock.AGE, "minecraft:cactus_age");
        this.register((IProperty<?>)CropsBlock.AGE, "minecraft:crops_age");
        this.register((IProperty<?>)NetherWartBlock.AGE, "minecraft:nether_wart_age");
        this.register((IProperty<?>)DoublePlantBlock.HALF, "minecraft:double_plant_half");
        this.register((IProperty<?>)StemBlock.AGE, "minecraft:stem_age");
        this.register((IProperty<?>)SaplingBlock.STAGE, "minecraft:sapling_stage");
        this.register((IProperty<?>)FenceBlock.NORTH, "minecraft:fence_north");
        this.register((IProperty<?>)FenceBlock.EAST, "minecraft:fence_east");
        this.register((IProperty<?>)FenceBlock.SOUTH, "minecraft:fence_south");
        this.register((IProperty<?>)FenceBlock.WEST, "minecraft:fence_west");
        this.register((IProperty<?>)PaneBlock.NORTH, "minecraft:pane_north");
        this.register((IProperty<?>)PaneBlock.EAST, "minecraft:pane_east");
        this.register((IProperty<?>)PaneBlock.SOUTH, "minecraft:pane_south");
        this.register((IProperty<?>)PaneBlock.WEST, "minecraft:pane_west");
        this.register((IProperty<?>)PistonHeadBlock.TYPE, "minecraft:piston_extension_type");
        this.register((IProperty<?>)PistonHeadBlock.SHORT, "minecraft:piston_extension_short");
        this.register((IProperty<?>)NetherPortalBlock.AXIS, "minecraft:portal_axis");
        this.register((IProperty<?>)RailBlock.SHAPE, "minecraft:rail_shape");
        this.register((IProperty<?>)PoweredRailBlock.POWERED, "minecraft:powered_rail_powered");
        this.register((IProperty<?>)PoweredRailBlock.SHAPE, "minecraft:powered_rail_shape");
        this.register((IProperty<?>)DetectorRailBlock.POWERED, "minecraft:detector_rail_powered");
        this.register((IProperty<?>)DetectorRailBlock.SHAPE, "minecraft:detector_rail_shape");
        this.register((IProperty<?>)GrassBlock.SNOWY, "minecraft:grass_snowy");
        this.register((IProperty<?>)CauldronBlock.LEVEL, "minecraft:cauldron_level");
        this.register((IProperty<?>)BannerBlock.ROTATION, "minecraft:banner_rotation");
        this.register((IProperty<?>)StandingSignBlock.ROTATION, "minecraft:standing_sign_rotation");
        this.register((IProperty<?>)BrewingStandBlock.HAS_BOTTLE[0], "minecraft:brewing_stand_1_has_bottle");
        this.register((IProperty<?>)BrewingStandBlock.HAS_BOTTLE[1], "minecraft:brewing_stand_2_has_bottle");
        this.register((IProperty<?>)BrewingStandBlock.HAS_BOTTLE[2], "minecraft:brewing_stand_3_has_bottle");
        this.register((IProperty<?>)HopperBlock.ENABLED, "minecraft:hopper_enabled");
        this.register((IProperty<?>)HopperBlock.FACING, "minecraft:hopper_facing");
        this.register((IProperty<?>)DaylightDetectorBlock.POWER, "minecraft:daylight_detector_power");
        this.register((IProperty<?>)DispenserBlock.TRIGGERED, "minecraft:dispenser_triggered");
        this.register((IProperty<?>)JukeboxBlock.HAS_RECORD, "minecraft:jukebox_has_record");
        this.register((IProperty<?>)CakeBlock.BITES, "minecraft:cake_bites");
        this.register((IProperty<?>)FireBlock.AGE, "minecraft:fire_age");
        this.register((IProperty<?>)FireBlock.NORTH, "minecraft:fire_north");
        this.register((IProperty<?>)FireBlock.EAST, "minecraft:fire_east");
        this.register((IProperty<?>)FireBlock.SOUTH, "minecraft:fire_south");
        this.register((IProperty<?>)FireBlock.WEST, "minecraft:fire_west");
        this.register((IProperty<?>)FireBlock.UP, "minecraft:fire_upper");
        this.register((IProperty<?>)TripWireHookBlock.ATTACHED, "minecraft:trip_wire_hook_attached");
        this.register((IProperty<?>)TripWireHookBlock.POWERED, "minecraft:trip_wire_hook_powered");
        this.register((IProperty<?>)DoorBlock.OPEN, "minecraft:door_open");
        this.register((IProperty<?>)DoorBlock.HINGE, "minecraft:door_hinge");
        this.register((IProperty<?>)DoorBlock.POWERED, "minecraft:door_powered");
        this.register((IProperty<?>)DoorBlock.HALF, "minecraft:door_half");
        this.register((IProperty<?>)LeverBlock.POWERED, "minecraft:lever_powered");
        this.register((IProperty<?>)BedBlock.PART, "minecraft:bed_part");
        this.register((IProperty<?>)BedBlock.OCCUPIED, "minecraft:bed_occupied");
        this.register((IProperty<?>)ComparatorBlock.MODE, "minecraft:comparator_mode");
        this.register((IProperty<?>)ComparatorBlock.POWERED, "minecraft:comparator_powered");
        this.register((IProperty<?>)CocoaBlock.AGE, "minecraft:cocoa_age");
        this.register((IProperty<?>)FenceGateBlock.IN_WALL, "minecraft:fence_gate_in_wall");
        this.register((IProperty<?>)FenceGateBlock.OPEN, "minecraft:fence_gate_open");
        this.register((IProperty<?>)FenceGateBlock.POWERED, "minecraft:fence_gate_powered");
        this.register((IProperty<?>)RedstoneWireBlock.NORTH, "minecraft:redstone_north");
        this.register((IProperty<?>)RedstoneWireBlock.EAST, "minecraft:redstone_east");
        this.register((IProperty<?>)RedstoneWireBlock.SOUTH, "minecraft:redstone_south");
        this.register((IProperty<?>)RedstoneWireBlock.WEST, "minecraft:redstone_west");
        this.register((IProperty<?>)RedstoneWireBlock.POWER, "minecraft:redstone_power");
        this.register((IProperty<?>)TripWireBlock.POWERED, "minecraft:trip_wire_powered");
        this.register((IProperty<?>)TripWireBlock.ATTACHED, "minecraft:trip_wire_attached");
        this.register((IProperty<?>)TripWireBlock.DISARMED, "minecraft:trip_wire_disarmed");
        this.register((IProperty<?>)TripWireBlock.NORTH, "minecraft:trip_wire_north");
        this.register((IProperty<?>)TripWireBlock.EAST, "minecraft:trip_wire_east");
        this.register((IProperty<?>)TripWireBlock.SOUTH, "minecraft:trip_wire_south");
        this.register((IProperty<?>)TripWireBlock.WEST, "minecraft:trip_wire_west");
        this.register((IProperty<?>)WeightedPressurePlateBlock.POWER, "minecraft:weighted_pressure_plate_power");
        this.register((IProperty<?>)PressurePlateBlock.POWERED, "minecraft:pressure_plate_power");
        this.register((IProperty<?>)TrapDoorBlock.OPEN, "minecraft:trap_door_open");
        this.register((IProperty<?>)TrapDoorBlock.HALF, "minecraft:trap_door_half");
        this.register((IProperty<?>)RepeaterBlock.DELAY, "minecraft:redstone_repeater_delay");
        this.register((IProperty<?>)RepeaterBlock.LOCKED, "minecraft:redstone_repeater_locked");
    }

    private static final class Holder {
        static final BlockPropertyIdProvider INSTANCE = new BlockPropertyIdProvider();

        private Holder() {
        }
    }
}

