/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.spongepowered.api.CatalogTypes;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.entity.EntityType;

final class TimingsPls {
    private static final Object2IntMap<EntityType<?>> ENTITY_IDS = new Object2IntOpenHashMap();
    private static final Object2IntMap<BlockEntityType> TILE_ENTITY_IDS = new Object2IntOpenHashMap();
    private static final int NOT_FOUND = Integer.MIN_VALUE;
    private static int nextEntityId = 56991891;
    private static int nextTileEntityId = 13221456;

    TimingsPls() {
    }

    public static int getEntityId(EntityType<?> type) {
        int fake = ENTITY_IDS.getInt(type);
        if (fake == Integer.MIN_VALUE) {
            fake = nextEntityId++;
            ENTITY_IDS.put(type, fake);
        }
        return fake;
    }

    public static int getTileEntityId(BlockEntityType type) {
        int fake = TILE_ENTITY_IDS.getInt((Object)type);
        if (fake == Integer.MIN_VALUE) {
            fake = nextTileEntityId++;
            TILE_ENTITY_IDS.put((Object)type, fake);
        }
        return fake;
    }

    static {
        ENTITY_IDS.defaultReturnValue(Integer.MIN_VALUE);
        int count = -1;
        for (BlockEntityType tileEntityType : Sponge.getGame().getRegistry().getCatalogRegistry().getAllOf(CatalogTypes.BLOCK_ENTITY_TYPE)) {
            TILE_ENTITY_IDS.put((Object)tileEntityType, count++);
        }
    }
}

