/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import com.google.common.collect.Lists;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.Validate;
import org.spongepowered.api.Server;
import org.spongepowered.api.adventure.Audiences;

public final class TimingsReportListener {
    private final List<Audience> channels;
    private final Runnable onDone;
    private String timingsURL;
    private ForwardingAudience audience;

    public TimingsReportListener(Audience sender, Runnable onDone) {
        this(Lists.newArrayList((Object[])new Audience[]{sender}), onDone);
    }

    public TimingsReportListener(List<Audience> channels) {
        this(channels, null);
    }

    public TimingsReportListener(List<Audience> channels, Runnable onDone) {
        Validate.notNull(channels);
        Validate.notEmpty(channels);
        this.channels = Lists.newArrayList(channels);
        this.addConsoleIfNeeded(this.channels);
        this.onDone = onDone;
        this.audience = Audience.audience(this.channels);
    }

    public String getTimingsURL() {
        return this.timingsURL;
    }

    public void done() {
        this.done(null);
    }

    public void done(String url) {
        this.timingsURL = url;
        if (this.onDone != null) {
            this.onDone.run();
        }
    }

    public void addConsoleIfNeeded(List<Audience> channels) {
        boolean hasConsole = false;
        for (Audience channel : channels) {
            if (!(channel instanceof Server)) continue;
            hasConsole = true;
            break;
        }
        if (!hasConsole) {
            channels.add(Audiences.server());
        }
    }

    public void send(Component text) {
        this.audience.sendMessage(Identity.nil(), text);
    }

    public ForwardingAudience getChannel() {
        return this.audience;
    }
}

