/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.scheduler.SpongeTask;

public final class SpongeScheduledTask
implements ScheduledTask {
    final SpongeTask task;
    private final SpongeScheduler scheduler;
    private final UUID id;
    private final String name;
    private long timestamp;
    private ScheduledTaskState state;
    private boolean isCancelled = false;

    SpongeScheduledTask(SpongeScheduler scheduler, SpongeTask task, String taskName) {
        this.scheduler = scheduler;
        this.id = UUID.randomUUID();
        this.name = taskName;
        this.task = task;
        this.state = ScheduledTaskState.WAITING;
    }

    @Override
    public UUID getUniqueId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Task getTask() {
        return this.task;
    }

    @Override
    public boolean cancel() {
        boolean success = false;
        if (this.getState() == ScheduledTaskState.RUNNING || this.getState() == ScheduledTaskState.EXECUTING) {
            success = true;
        }
        this.state = ScheduledTaskState.CANCELED;
        this.isCancelled = true;
        return success;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    public SpongeScheduler getScheduler() {
        return this.scheduler;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    long nextExecutionTimestamp() {
        if (this.state.isActive) {
            return this.timestamp + this.task.interval;
        }
        return this.timestamp + this.task.delay;
    }

    ScheduledTaskState getState() {
        return this.state;
    }

    void setState(ScheduledTaskState state) {
        this.state = state;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("id", (Object)this.id).add("task", (Object)this.task).toString();
    }

    public static enum ScheduledTaskState {
        WAITING(false),
        SWITCHING(true),
        EXECUTING(true),
        RUNNING(true),
        CANCELED(false);

        public final boolean isActive;

        private ScheduledTaskState(boolean active) {
            this.isActive = active;
        }
    }
}

