/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard.builder;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.scoreboard.ScorePlayerTeam;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeTeamBuilder
implements Team.Builder {
    @Nullable
    private String name;
    @Nullable
    private Component displayName;
    private NamedTextColor color;
    private Component prefix;
    private Component suffix;
    private boolean allowFriendlyFire;
    private boolean showFriendlyInvisibles;
    private Supplier<? extends Visibility> nameTagVisibility;
    private Supplier<? extends Visibility> deathMessageVisibility;
    private Supplier<? extends CollisionRule> collisionRule;
    private Set<Component> members;

    public SpongeTeamBuilder() {
        this.reset();
    }

    @Override
    public Team.Builder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null!");
        Preconditions.checkState((name.length() < 17 ? 1 : 0) != 0, (Object)("Name is " + name.length() + " characters long! It must be at most 16."));
        if (this.displayName == null) {
            this.displayName = Component.text((String)this.name);
        }
        return this;
    }

    @Override
    public Team.Builder color(NamedTextColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"Color cannot be null!");
        this.color = color;
        return this;
    }

    @Override
    public Team.Builder displayName(Component displayName) throws IllegalArgumentException {
        int length = SpongeAdventure.legacySection(displayName).length();
        Preconditions.checkState((length < 33 ? 1 : 0) != 0, (Object)("DisplayName is " + length + " characters long! It must be at most 32."));
        this.displayName = (Component)Preconditions.checkNotNull((Object)displayName, (Object)"DisplayName cannot be null!");
        return this;
    }

    @Override
    public Team.Builder prefix(Component prefix) {
        this.prefix = (Component)Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null!");
        return this;
    }

    @Override
    public Team.Builder suffix(Component suffix) {
        this.suffix = (Component)Preconditions.checkNotNull((Object)suffix, (Object)"Suffix cannot be null!");
        return this;
    }

    @Override
    public Team.Builder allowFriendlyFire(boolean enabled) {
        this.allowFriendlyFire = enabled;
        return this;
    }

    @Override
    public Team.Builder canSeeFriendlyInvisibles(boolean enabled) {
        this.showFriendlyInvisibles = enabled;
        return this;
    }

    @Override
    public Team.Builder nameTagVisibility(Visibility visibility) {
        Preconditions.checkNotNull((Object)visibility, (Object)"Visibility cannot be null!");
        this.nameTagVisibility = () -> visibility;
        return this;
    }

    @Override
    public Team.Builder deathTextVisibility(Visibility visibility) {
        Preconditions.checkNotNull((Object)visibility, (Object)"Visibility cannot be null!");
        this.deathMessageVisibility = () -> visibility;
        return this;
    }

    @Override
    public Team.Builder collisionRule(CollisionRule rule) {
        Preconditions.checkNotNull((Object)rule, (Object)"Collision rule cannot be null!");
        this.collisionRule = () -> rule;
        return this;
    }

    @Override
    public Team.Builder members(Set<Component> members) {
        this.members = new HashSet<Component>((Collection)Preconditions.checkNotNull(members, (Object)"Members cannot be null!"));
        return this;
    }

    @Override
    public Team.Builder from(Team value) {
        this.name(value.getName()).displayName(value.getDisplayName()).prefix(value.getPrefix()).color(value.getColor()).allowFriendlyFire(value.allowFriendlyFire()).canSeeFriendlyInvisibles(value.canSeeFriendlyInvisibles()).suffix(value.getSuffix()).nameTagVisibility(value.getNameTagVisibility()).deathTextVisibility(value.getDeathMessageVisibility()).collisionRule(value.getCollisionRule()).members(value.getMembers());
        return this;
    }

    @Override
    public SpongeTeamBuilder reset() {
        this.name = null;
        this.displayName = null;
        this.color = NamedTextColor.WHITE;
        this.prefix = Component.empty();
        this.suffix = Component.empty();
        this.allowFriendlyFire = false;
        this.showFriendlyInvisibles = false;
        this.nameTagVisibility = Visibilities.ALWAYS;
        this.deathMessageVisibility = Visibilities.ALWAYS;
        this.collisionRule = CollisionRules.ALWAYS;
        this.members = new HashSet<Component>();
        return this;
    }

    @Override
    public Team build() throws IllegalStateException {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name cannot be null!");
        Preconditions.checkState((this.displayName != null ? 1 : 0) != 0, (Object)"DisplayName cannot be null!");
        Team team = (Team)new ScorePlayerTeam(null, this.name);
        team.setDisplayName(this.displayName);
        team.setColor(this.color);
        team.setPrefix(this.prefix);
        team.setSuffix(this.suffix);
        team.setAllowFriendlyFire(this.allowFriendlyFire);
        team.setCanSeeFriendlyInvisibles(this.showFriendlyInvisibles);
        team.setNameTagVisibility(this.nameTagVisibility.get());
        team.setDeathMessageVisibility(this.deathMessageVisibility.get());
        team.setCollisionRule(this.collisionRule.get());
        for (Component member : this.members) {
            team.addMember(member);
        }
        return team;
    }
}

