/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.PrimitiveIterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.math.GenericMath;

final class PaginationCalculator {
    private static final String NON_UNICODE_CHARS;
    private static final int[] NON_UNICODE_CHAR_WIDTHS;
    private static final byte[] UNICODE_CHAR_WIDTHS;
    private static final int LINE_WIDTH = 320;
    private final int linesPerPage;

    PaginationCalculator(int linesPerPage) {
        this.linesPerPage = linesPerPage;
    }

    int getLinesPerPage() {
        return this.linesPerPage;
    }

    int getLines(Component text) {
        return (int)Math.ceil((double)this.getWidth(text) / 320.0);
    }

    @VisibleForTesting
    int getWidth(int codePoint, boolean isBold) {
        int width;
        int nonUnicodeIdx = NON_UNICODE_CHARS.indexOf(codePoint);
        if (codePoint == 32) {
            width = 4;
        } else if (codePoint > 0 && nonUnicodeIdx != -1) {
            width = NON_UNICODE_CHAR_WIDTHS[nonUnicodeIdx];
        } else if (UNICODE_CHAR_WIDTHS[codePoint] != 0) {
            int temp = UNICODE_CHAR_WIDTHS[codePoint] & 0xFF;
            int startColumn = temp >>> 4;
            int endColumn = temp & 0xF;
            width = endColumn + 1 - startColumn;
            width = width / 2 + 1;
        } else {
            width = 0;
        }
        if (isBold && width > 0) {
            ++width;
        }
        return width;
    }

    @VisibleForTesting
    int getWidth(Component text) {
        ITextComponent children = SpongeAdventure.asVanilla(text);
        int total = 0;
        for (ITextComponent child : children) {
            if (!(child instanceof StringTextComponent) && !(child instanceof TranslationTextComponent)) continue;
            PrimitiveIterator.OfInt i_it = child.getUnformattedComponentText().codePoints().iterator();
            boolean bold = child.getStyle().getBold();
            boolean newLine = false;
            while (i_it.hasNext()) {
                Integer cp = i_it.next();
                if (cp == 10) {
                    if (newLine) {
                        total += 320;
                        continue;
                    }
                    total = (int)Math.ceil((double)total / 320.0) * 320;
                    newLine = true;
                    continue;
                }
                int width = this.getWidth(cp, bold);
                total += width;
                newLine = false;
            }
        }
        return total;
    }

    Component center(Component text, Component padding) {
        int inputLength = this.getWidth(text);
        if (inputLength >= 320) {
            return text;
        }
        Component textWithSpaces = this.addSpaces((Component)Component.space(), text);
        boolean addSpaces = this.getWidth(textWithSpaces) <= 320;
        int paddingLength = this.getWidth(padding);
        TextComponent.Builder output = Component.text();
        if (paddingLength < 1) {
            padding = Component.text((String)"=");
            paddingLength = this.getWidth(padding);
        }
        if (inputLength == 0) {
            this.addPadding(padding, output, GenericMath.floor((double)(320.0 / (double)paddingLength)));
        } else {
            if (addSpaces) {
                text = textWithSpaces;
                inputLength = this.getWidth(textWithSpaces);
            }
            int paddingNecessary = 320 - inputLength;
            int paddingCount = GenericMath.floor((float)(paddingNecessary / paddingLength));
            int beforePadding = GenericMath.floor((double)((double)paddingCount / 2.0));
            int afterPadding = paddingCount - beforePadding - 1;
            this.addPadding(padding, output, beforePadding);
            output.append(text);
            this.addPadding(padding, output, afterPadding);
        }
        return this.finalizeBuilder(text, output);
    }

    private Component finalizeBuilder(Component text, TextComponent.Builder build) {
        return ((TextComponent.Builder)build.style(text.style())).build();
    }

    private Component addSpaces(Component spaces, Component text) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(spaces)).append(text)).append(spaces)).style(text.style())).build();
    }

    private void addPadding(Component padding, TextComponent.Builder build, int count) {
        if (count > 0) {
            build.append(Collections.nCopies(count, padding));
        }
    }

    static {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().url(PaginationCalculator.class.getResource("font-sizes.json"))).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            NON_UNICODE_CHARS = ((CommentedConfigurationNode)node.node(new Object[]{"non-unicode"})).getString();
            NON_UNICODE_CHAR_WIDTHS = ((CommentedConfigurationNode)node.node(new Object[]{"char-widths"})).get(int[].class, ArrayUtils.EMPTY_INT_ARRAY);
            UNICODE_CHAR_WIDTHS = ((CommentedConfigurationNode)node.node(new Object[]{"glyph-widths"})).get(byte[].class, ArrayUtils.EMPTY_BYTE_ARRAY);
        }
        catch (ConfigurateException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

