/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.common.service.game.pagination.SpongePaginationList;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;

public final class SpongePaginationBuilder
implements PaginationList.Builder {
    private static final @NonNull Component EQUALS_TEXT = Component.text((String)"=");
    private final SpongePaginationService service;
    @Nullable
    private Iterable<Component> contents;
    @Nullable
    private Component title;
    @Nullable
    private Component header;
    @Nullable
    private Component footer;
    private Component paginationSpacer = EQUALS_TEXT;
    private int linesPerPage = 20;
    @Nullable
    private PaginationList paginationList;

    public SpongePaginationBuilder(SpongePaginationService service) {
        this.service = service;
    }

    @Override
    public PaginationList.Builder contents(Iterable<Component> contents) {
        Preconditions.checkNotNull(contents, (Object)"The contents cannot be null!");
        this.contents = contents;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder contents(Component ... contents) {
        Preconditions.checkNotNull((Object)contents, (Object)"The contents cannot be null!");
        this.contents = ImmutableList.copyOf((Object[])contents);
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder title(@Nullable Component title) {
        this.title = title;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder header(@Nullable Component header) {
        this.header = header;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder footer(@Nullable Component footer) {
        this.footer = footer;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder padding(Component padding) {
        Preconditions.checkNotNull((Object)padding, (Object)"The padding cannot be null!");
        this.paginationSpacer = padding;
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder linesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
        return this;
    }

    @Override
    public PaginationList build() {
        Preconditions.checkState((this.contents != null ? 1 : 0) != 0, (Object)"The contents of the pagination list cannot be null!");
        if (this.paginationList == null) {
            this.paginationList = new SpongePaginationList(this.service, this.contents, this.title, this.header, this.footer, this.paginationSpacer, this.linesPerPage);
        }
        return this.paginationList;
    }

    @Override
    public PaginationList.Builder from(PaginationList list) {
        this.reset();
        this.contents = list.getContents();
        this.title = list.getTitle().orElse(null);
        this.header = list.getHeader().orElse(null);
        this.footer = list.getFooter().orElse(null);
        this.paginationSpacer = list.getPadding();
        this.paginationList = null;
        return this;
    }

    @Override
    public PaginationList.Builder reset() {
        this.contents = null;
        this.title = null;
        this.header = null;
        this.footer = null;
        this.paginationSpacer = EQUALS_TEXT;
        this.paginationList = null;
        return this;
    }
}

