/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.server.permission.SpongePermissionService;

public final class SpongePermissions {
    private static final Set<String> REGISTERED_PERMISSIONS = new HashSet<String>();

    private SpongePermissions() {
    }

    public static void populateNonCommandPermissions(SubjectData data, BiFunction<Integer, String, Boolean> testPermission) {
        if (testPermission.apply(2, "").booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.commandblock", Tristate.TRUE);
        }
        if (testPermission.apply(2, "@").booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.selector", Tristate.TRUE);
        }
        if (testPermission.apply(0, "sponge:help").booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, "sponge.command.help", Tristate.TRUE);
        }
        if (testPermission.apply(1, "minecraft.login.bypass-whitelist").booleanValue()) {
            data.setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.login.bypass-whitelist", Tristate.TRUE);
        }
    }

    public static void registerPermission(String permissionNode, int opLevel) {
        if (REGISTERED_PERMISSIONS.add(permissionNode)) {
            PermissionService service = Sponge.getServer().getServiceProvider().permissionService();
            if (opLevel == 0) {
                service.getDefaults().getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, permissionNode, Tristate.TRUE);
            }
            if (service instanceof SpongePermissionService) {
                ((SpongePermissionService)service).getGroupForOpLevel(opLevel).getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, permissionNode, Tristate.TRUE);
            }
        }
    }
}

