/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.serializer;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.common.accessor.util.text.StringTextComponentAccessor;
import org.spongepowered.common.accessor.util.text.StyleAccessor;
import org.spongepowered.common.accessor.util.text.TextFormattingAccessor;

public final class LegacyTexts {
    private static final int FORMATTING_CODE_LENGTH = 2;
    private static final TextFormatting[] formatting = TextFormatting.values();
    private static final String LOOKUP;

    private LegacyTexts() {
    }

    public static int getFormattingCount() {
        return formatting.length;
    }

    public static int findFormat(char format) {
        int pos = LOOKUP.indexOf(format);
        if (pos == -1) {
            pos = LOOKUP.indexOf(Character.toLowerCase(format));
        }
        return pos;
    }

    public static boolean isFormat(char format) {
        return LegacyTexts.findFormat(format) != -1;
    }

    @Nullable
    public static TextFormatting parseFormat(char format) {
        int pos = LegacyTexts.findFormat(format);
        return pos != -1 ? formatting[pos] : null;
    }

    public static StringTextComponent parseComponent(StringTextComponent component, char code) {
        String text = component.getText();
        int next = text.lastIndexOf(code, text.length() - 2);
        ArrayList<StringTextComponent> parsed = null;
        if (next >= 0) {
            parsed = new ArrayList<StringTextComponent>();
            StringTextComponent current = null;
            boolean reset = false;
            int pos = text.length();
            do {
                TextFormatting format;
                if ((format = LegacyTexts.parseFormat(text.charAt(next + 1))) == null) continue;
                int from = next + 2;
                if (from != pos) {
                    if (current != null) {
                        if (reset) {
                            parsed.add(current);
                            LegacyTexts.setParentIfNotSame(current.getStyle(), component.getStyle());
                            reset = false;
                            current = new StringTextComponent("");
                        } else {
                            StringTextComponent old = current;
                            current = new StringTextComponent("");
                            current.appendSibling((ITextComponent)old);
                        }
                    } else {
                        current = new StringTextComponent("");
                    }
                    ((StringTextComponentAccessor)current).accessor$setText(text.substring(from, pos));
                } else if (current == null) {
                    current = new StringTextComponent("");
                }
                reset |= LegacyTexts.applyStyle(current.getStyle(), format);
                pos = next;
            } while ((next = text.lastIndexOf(code, next - 1)) != -1);
            if (current != null) {
                parsed.add(current);
                LegacyTexts.setParentIfNotSame(current.getStyle(), component.getStyle());
            }
            Collections.reverse(parsed);
            String string = text = pos > 0 ? text.substring(0, pos) : "";
            if (component.getSiblings().isEmpty()) {
                StringTextComponent newComponent = new StringTextComponent(text);
                newComponent.getSiblings().addAll(parsed);
                newComponent.setStyle(component.getStyle());
                return newComponent;
            }
        } else if (component.getSiblings().isEmpty()) {
            return component;
        }
        StringTextComponent newComponent = new StringTextComponent(text);
        if (parsed != null) {
            newComponent.getSiblings().addAll(parsed);
        }
        newComponent.setStyle(component.getStyle());
        for (Object child : component.getSiblings()) {
            child = child instanceof StringTextComponent ? LegacyTexts.parseComponent((StringTextComponent)child, code) : child.shallowCopy();
            newComponent.appendSibling(child);
        }
        return newComponent;
    }

    private static void setParentIfNotSame(Style child, Style parent) {
        if (parent != child) {
            child.setParentStyle(parent);
        }
    }

    private static boolean applyStyle(Style style, TextFormatting formatting) {
        switch (formatting) {
            case BOLD: {
                ((StyleAccessor)style).accessor$setBold(true);
                break;
            }
            case ITALIC: {
                ((StyleAccessor)style).accessor$setItalic(true);
                break;
            }
            case UNDERLINE: {
                ((StyleAccessor)style).accessor$setUnderlined(true);
                break;
            }
            case STRIKETHROUGH: {
                ((StyleAccessor)style).accessor$setStrikethrough(true);
                break;
            }
            case OBFUSCATED: {
                ((StyleAccessor)style).accessor$setObfuscated(true);
                break;
            }
            default: {
                if (((StyleAccessor)style).accessor$getColor() == null) {
                    ((StyleAccessor)style).accessor$setColor(formatting);
                }
                return true;
            }
        }
        return false;
    }

    public static String replace(String text, char from, char to) {
        int pos;
        int last = text.length() - 1;
        if (pos == -1 || pos == last) {
            return text;
        }
        char[] result = text.toCharArray();
        for (pos = text.indexOf(from); pos < last; ++pos) {
            if (result[pos] != from || !LegacyTexts.isFormat(result[pos + 1])) continue;
            result[pos] = to;
        }
        return new String(result);
    }

    static {
        char[] lookup = new char[formatting.length];
        for (int i = 0; i < formatting.length; ++i) {
            lookup[i] = ((TextFormattingAccessor)formatting[i]).accessor$getFormattingCode();
        }
        LOOKUP = new String(lookup);
    }
}

