/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.user;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.Server;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.user.UserManager;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.user.ServerUserProvider;

public final class SpongeUserManager
implements UserManager {
    public static final UUID FAKEPLAYER_UUID = UUID.fromString("41C82C87-7AFB-4024-BA57-13D2C99CAE77");
    public static final GameProfile FAKEPLAYER_PROFILE = new SpongeGameProfile(FAKEPLAYER_UUID, null);
    private final ServerUserProvider serverUserProvider;

    public SpongeUserManager(Server server) {
        this.serverUserProvider = new ServerUserProvider(server);
    }

    public void init() {
        this.serverUserProvider.refreshFilesystemProfiles();
        this.serverUserProvider.setupWatchers();
    }

    @Override
    public Optional<User> get(UUID uniqueId) {
        return this.serverUserProvider.getUser(uniqueId);
    }

    @Override
    public Optional<User> get(String lastKnownName) {
        Preconditions.checkNotNull((Object)lastKnownName, (Object)"lastKnownName");
        Preconditions.checkArgument((!lastKnownName.isEmpty() && lastKnownName.length() <= 16 ? 1 : 0) != 0, (String)"Invalid username %s", (Object)lastKnownName);
        return this.serverUserProvider.getUser(lastKnownName);
    }

    @Override
    public Optional<User> get(GameProfile profile) {
        return this.serverUserProvider.getUser(profile);
    }

    @Override
    public User getOrCreate(GameProfile profile) {
        return this.serverUserProvider.getOrCreateUser(this.ensureNonEmptyUUID(profile), false);
    }

    public User forceRecreateUser(GameProfile profile) {
        return this.serverUserProvider.getOrCreateUser(profile, true);
    }

    @Override
    public Collection<GameProfile> getAll() {
        return this.streamAll().collect(Collectors.toList());
    }

    @Override
    public Stream<GameProfile> streamAll() {
        return this.serverUserProvider.streamAll();
    }

    @Override
    public boolean delete(GameProfile profile) {
        return this.serverUserProvider.deleteUser(((GameProfile)Preconditions.checkNotNull((Object)profile, (Object)"profile")).getUniqueId());
    }

    @Override
    public boolean delete(User user) {
        return this.delete(user.getProfile());
    }

    @Override
    public Stream<GameProfile> streamOfMatches(String lastKnownName) {
        return this.serverUserProvider.matchKnownProfiles(((String)Preconditions.checkNotNull((Object)lastKnownName, (Object)"lastKnownName")).toLowerCase(Locale.ROOT));
    }

    private GameProfile ensureNonEmptyUUID(GameProfile profile) {
        if (profile.getUniqueId().equals(SpongeGameProfile.EMPTY_UUID)) {
            String name = profile.getName().orElse(null);
            return new SpongeGameProfile(FAKEPLAYER_UUID, name);
        }
        return profile;
    }
}

