/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.Streams;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;

public final class NBTStreams {
    public static Stream<CompoundNBT> toCompounds(Iterable<INBT> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof CompoundNBT).map(tag -> (CompoundNBT)tag);
    }

    public static Stream<String> toStrings(Iterable<INBT> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof StringNBT).map(INBT::getString);
    }

    public static LongStream toLongs(Iterable<INBT> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof NumberNBT).mapToLong(tag -> ((NumberNBT)tag).getLong());
    }

    public static IntStream toInts(Iterable<INBT> iterable) {
        return Streams.stream(iterable).filter(tag -> tag instanceof NumberNBT).mapToInt(tag -> ((NumberNBT)tag).getInt());
    }

    private NBTStreams() {
    }
}

