/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.util.CatalogBuilder;
import org.spongepowered.api.util.ResettableBuilder;

public abstract class SpongeCatalogBuilder<C extends CatalogType, B extends ResettableBuilder<C, B>>
implements CatalogBuilder<C, B> {
    protected @Nullable ResourceKey key;

    @Override
    public B key(ResourceKey key) {
        Objects.requireNonNull(key);
        if (key.getNamespace().isEmpty()) {
            throw new IllegalArgumentException("The key namespace cannot be empty!");
        }
        if (key.getValue().isEmpty()) {
            throw new IllegalArgumentException("The key value cannot be empty!");
        }
        this.key = key;
        return (B)this;
    }

    @Override
    public C build() {
        Objects.requireNonNull(this.key);
        return this.build(this.key);
    }

    protected abstract C build(ResourceKey var1);

    @Override
    public B reset() {
        this.key = null;
        return (B)this;
    }
}

