/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Engine;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.util.Constants;

public final class SpongeTicks
implements Ticks {
    private final long ticks;
    private final Duration effectiveMinimumDuration;

    public SpongeTicks(long ticks) {
        this.ticks = ticks;
        this.effectiveMinimumDuration = Constants.TickConversions.EFFECTIVE_MINIMUM_DURATION.multipliedBy(this.ticks);
    }

    @Override
    public long getMinecraftSeconds(@NonNull Engine engine) {
        return 3600L * this.ticks / 1000L + (long)((double)(this.ticks % 1000L) / 0.2777777777777778);
    }

    @Override
    public @NonNull Duration getMinecraftDayTimeDuration(@NonNull Engine engine) {
        return Duration.of(this.getMinecraftSeconds(engine), ChronoUnit.SECONDS);
    }

    @Override
    public @NonNull Duration getExpectedDuration(@NonNull Engine engine) {
        return this.effectiveMinimumDuration;
    }

    @Override
    public long getTicks() {
        return this.ticks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeTicks that = (SpongeTicks)o;
        return this.ticks == that.ticks;
    }

    public int hashCode() {
        return Objects.hash(this.ticks);
    }

    public static final class Factory
    implements Ticks.Factory {
        private final Ticks zero = new SpongeTicks(0L);
        private final Ticks single = new SpongeTicks(1L);
        private final Ticks minecraftHour = new SpongeTicks(1000L);
        private final Ticks minecraftDay = new SpongeTicks(24000L);

        @Override
        public @NonNull Ticks of(long ticks) {
            if (ticks < 0L) {
                throw new IllegalArgumentException("Tick must be greater than 0!");
            }
            return new SpongeTicks(ticks);
        }

        @Override
        public @NonNull Ticks ofWallClockTime(@NonNull Engine engine, long time, @NonNull TemporalUnit temporalUnit) {
            Objects.requireNonNull(engine);
            if (time < 0L) {
                throw new IllegalArgumentException("Time must be greater than 0!");
            }
            Objects.requireNonNull(temporalUnit);
            long target = temporalUnit.getDuration().multipliedBy(time).toMillis();
            return this.of((long)Math.ceil((double)target / 50.0));
        }

        @Override
        public @NonNull Ticks ofMinecraftSeconds(@NonNull Engine engine, long seconds) {
            Objects.requireNonNull(engine);
            if (seconds < 0L) {
                throw new IllegalArgumentException("Seconds must be greater than 0!");
            }
            return this.of((long)Math.ceil((double)seconds * 0.2777777777777778));
        }

        @Override
        public @NonNull Ticks ofMinecraftHours(@NonNull Engine engine, long hours) {
            Objects.requireNonNull(engine);
            if (hours < 0L) {
                throw new IllegalArgumentException("Hours must be greater than 0!");
            }
            return this.of(hours * 1000L);
        }

        @Override
        public Ticks zero() {
            return this.zero;
        }

        @Override
        public Ticks single() {
            return this.single;
        }

        @Override
        public Ticks minecraftHour() {
            return this.minecraftHour;
        }

        @Override
        public Ticks minecraftDay() {
            return this.minecraftDay;
        }
    }
}

