/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.common.bridge.api.LocationBridge;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class VecHelper {
    public static BlockPos toBlockPos(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new BlockPos(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockPos toBlockPos(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new BlockPos(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockPos toBlockPos(ServerLocation location) {
        if (location == null) {
            return null;
        }
        return ((LocationBridge)((Object)location)).bridge$getBlockPos();
    }

    public static Vector3i toVector3i(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3i(pos.getX(), pos.getY(), pos.getZ());
    }

    public static Vector3d toVector3d(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3d((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
    }

    public static Vector3d toVector3d(Rotations rotation) {
        if (rotation == null) {
            return null;
        }
        return new Vector3d(rotation.getX(), rotation.getY(), rotation.getZ());
    }

    public static Vector3i toVector3i(Vec3i vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vec3i toVec3i(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vec3d toVec3d(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3d(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vec3d toVec3d(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vec3d((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static Vector3i toVec3i(ChunkPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3i(pos.x, 0, pos.z);
    }

    public static ChunkPos toChunkPos(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new ChunkPos(vector.getX(), vector.getZ());
    }

    public static Vector3d toVector3d(Vec3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3d(vector.x, vector.y, vector.z);
    }

    public static Vec3i toVec3i(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vec3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Rotations toRotation(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Rotations((float)vector.getX(), (float)vector.getY(), (float)vector.getZ());
    }

    public static boolean inBounds(int x, int y, Vector2i min2, Vector2i max) {
        return x >= min2.getX() && x <= max.getX() && y >= min2.getY() && y <= max.getY();
    }

    public static boolean inBounds(int x, int y, int z, Vector3i min2, Vector3i max) {
        return x >= min2.getX() && x <= max.getX() && y >= min2.getY() && y <= max.getY() && z >= min2.getZ() && z <= max.getZ();
    }

    public static boolean inBounds(Vector3d pos, Vector3i min2, Vector3i max) {
        return VecHelper.inBounds(pos.getX(), pos.getY(), pos.getZ(), min2, max);
    }

    public static boolean inBounds(double x, double y, double z, Vector3i min2, Vector3i max) {
        return x >= (double)min2.getX() && x <= (double)max.getX() && y >= (double)min2.getY() && y <= (double)max.getY() && z >= (double)min2.getZ() && z <= (double)max.getZ();
    }

    public static AxisAlignedBB toMinecraftAABB(AABB box) {
        if (box == null) {
            return null;
        }
        return new AxisAlignedBB(box.getMin().getX(), box.getMin().getY(), box.getMin().getZ(), box.getMax().getX(), box.getMax().getY(), box.getMax().getZ());
    }

    public static AABB toSpongeAABB(AxisAlignedBB box) {
        if (box == null) {
            return null;
        }
        return new AABB(new Vector3d(box.minX, box.minY, box.minZ), new Vector3d(box.maxX, box.maxY, box.maxZ));
    }

    public static CompoundNBT toCompound(Vector3d vector) {
        CompoundNBT compound = new CompoundNBT();
        compound.putDouble("x", vector.getX());
        compound.putDouble("y", vector.getY());
        compound.putDouble("z", vector.getZ());
        return compound;
    }

    public static Vector3d fromCompound(CompoundNBT compound) {
        return new Vector3d(compound.getDouble("x"), compound.getDouble("y"), compound.getDouble("z"));
    }

    private VecHelper() {
    }
}

