/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.blockray.RayTrace;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.util.raytrace.SpongeBlockRayTrace;
import org.spongepowered.common.util.raytrace.SpongeEntityRayTrace;

public final class SpongeRayTraceFactory
implements RayTrace.Factory {
    private final Predicate<LocatableBlock> onlyAir = locatableBlock -> {
        BlockType type = locatableBlock.getBlockState().getType();
        return type == BlockTypes.AIR.get() || type == BlockTypes.CAVE_AIR.get() || type == BlockTypes.VOID_AIR.get();
    };
    private final Predicate<LocatableBlock> notAir = this.onlyAir.negate();

    @Override
    public @NonNull RayTrace<@NonNull Entity> entityRayTrace() {
        return new SpongeEntityRayTrace();
    }

    @Override
    public @NonNull RayTrace<@NonNull LocatableBlock> blockRayTrace() {
        return new SpongeBlockRayTrace();
    }

    @Override
    public Predicate<LocatableBlock> onlyAir() {
        return this.onlyAir;
    }

    @Override
    public @NonNull Predicate<LocatableBlock> notAir() {
        return this.notAir;
    }
}

