/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.common.bridge.api.LocationBridge;
import org.spongepowered.common.util.MemoizedSupplier;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.SpongeLocation;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeServerLocation
extends SpongeLocation<ServerWorld>
implements ServerLocation,
LocationBridge {
    private final Supplier<BlockPos> posSupplier = MemoizedSupplier.memoize(() -> {
        Vector3i blockPosition = this.getBlockPosition();
        return new BlockPos(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
    });

    SpongeServerLocation(ServerWorld world, ChunkLayout chunkLayout, Vector3d position) {
        super(world, chunkLayout, position);
    }

    SpongeServerLocation(ServerWorld worldRef, Vector3d position, Vector3i chunkPosition, Vector3i biomePosition) {
        super(worldRef, position, chunkPosition, biomePosition);
    }

    @Override
    public ServerLocation withWorld(ServerWorld world) {
        return new SpongeServerLocation(world, this.getPosition(), this.getChunkPosition(), this.getBiomePosition());
    }

    @Override
    public ServerLocation withPosition(Vector3d position) {
        ChunkLayout chunkLayout = ((ServerWorld)this.getWorld()).getEngine().getChunkLayout();
        return new SpongeServerLocation((ServerWorld)this.getWorld(), chunkLayout, position);
    }

    @Override
    public ServerLocation withBlockPosition(Vector3i position) {
        ChunkLayout chunkLayout = ((ServerWorld)this.getWorld()).getEngine().getChunkLayout();
        return new SpongeServerLocation((ServerWorld)this.getWorld(), chunkLayout, position.toDouble());
    }

    @Override
    public ServerLocation sub(Vector3d v) {
        return this.withPosition(this.getPosition().sub(v));
    }

    @Override
    public ServerLocation sub(Vector3i v) {
        return this.withBlockPosition(this.getBlockPosition().sub(v));
    }

    @Override
    public ServerLocation sub(double x, double y, double z) {
        return this.withPosition(this.getPosition().sub(x, y, z));
    }

    @Override
    public ServerLocation add(Vector3d v) {
        return this.withPosition(this.getPosition().add(v));
    }

    @Override
    public ServerLocation add(Vector3i v) {
        return this.withBlockPosition(this.getBlockPosition().add(v));
    }

    @Override
    public ServerLocation add(double x, double y, double z) {
        return this.withPosition(this.getPosition().add(x, y, z));
    }

    @Override
    public ServerLocation relativeTo(Direction direction) {
        return this.add(direction.asOffset());
    }

    @Override
    public ServerLocation relativeToBlock(Direction direction) {
        return this.add(direction.asBlockOffset());
    }

    @Override
    public ResourceKey getWorldKey() {
        return ((ServerWorld)this.getWorld()).getKey();
    }

    @Override
    public LocatableBlock asLocatableBlock() {
        return new SpongeLocatableBlockBuilder().location(this).build();
    }

    @Override
    public <T> T map(BiFunction<ServerWorld, Vector3d, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "map");
    }

    @Override
    public <T> T mapBlock(BiFunction<ServerWorld, Vector3i, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "mapBlock");
    }

    @Override
    public <T> T mapChunk(BiFunction<ServerWorld, Vector3i, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "mapChunk");
    }

    @Override
    public <T> T mapBiome(BiFunction<ServerWorld, Vector3i, T> mapper) {
        throw new MissingImplementationException("ServerLocation", "mapBiome");
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return false;
    }

    @Override
    public boolean removeBlock() {
        return ((ServerWorld)this.getWorld()).removeBlock(this.getBlockPosition());
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type) {
        return (E)((ServerWorld)this.getWorld()).createEntity(type, this.getPosition());
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        return ((ServerWorld)this.getWorld()).spawnEntity(entity);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return ((ServerWorld)this.getWorld()).spawnEntities(entities);
    }

    @Override
    public ServerLocation asHighestLocation() {
        return this.withBlockPosition(((ServerWorld)this.getWorld()).getHighestPositionAt(this.getBlockPosition()));
    }

    @Override
    public BlockSnapshot createSnapshot() {
        return ((ServerWorld)this.getWorld()).createSnapshot(this.getBlockPosition());
    }

    @Override
    public Collection<? extends ScheduledUpdate<BlockType>> getScheduledBlockUpdates() {
        return ((ServerWorld)this.getWorld()).getScheduledBlockUpdates().getScheduledAt(this.getBlockPosition());
    }

    @Override
    public ScheduledUpdate<BlockType> scheduleBlockUpdate(int delay, TemporalUnit temporalUnit) {
        throw new MissingImplementationException("ServerLocation", "scheduleBlockUpdate");
    }

    @Override
    public ScheduledUpdate<BlockType> scheduleBlockUpdate(int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        throw new MissingImplementationException("ServerLocation", "scheduleBlockUpdate");
    }

    @Override
    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Duration delay) {
        throw new MissingImplementationException("ServerLocation", "scheduleBlockUpdate");
    }

    @Override
    public ScheduledUpdate<BlockType> scheduleBlockUpdate(Duration delay, TaskPriority priority) {
        throw new MissingImplementationException("ServerLocation", "scheduleBlockUpdate");
    }

    @Override
    public Collection<? extends ScheduledUpdate<FluidType>> getScheduledFluidUpdates() {
        return ((ServerWorld)this.getWorld()).getScheduledFluidUpdates().getScheduledAt(this.getBlockPosition());
    }

    @Override
    public ScheduledUpdate<FluidType> scheduleFluidUpdate(int delay, TemporalUnit temporalUnit) {
        throw new MissingImplementationException("ServerLocation", "scheduleFluidUpdate");
    }

    @Override
    public ScheduledUpdate<FluidType> scheduleFluidUpdate(int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        throw new MissingImplementationException("ServerLocation", "scheduleFluidUpdate");
    }

    @Override
    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Duration delay) {
        throw new MissingImplementationException("ServerLocation", "scheduleFluidUpdate");
    }

    @Override
    public ScheduledUpdate<FluidType> scheduleFluidUpdate(Duration delay, TaskPriority priority) {
        throw new MissingImplementationException("ServerLocation", "scheduleFluidUpdate");
    }

    @Override
    public <E> DataTransactionResult transform(Key<? extends Value<E>> key, Function<E, E> function) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, function);
    }

    @Override
    public <E> DataTransactionResult offer(Key<? extends Value<E>> key, E value) {
        return ((ServerWorld)this.getWorld()).offer(this.getBlockPosition(), key, value);
    }

    @Override
    public DataTransactionResult offer(Value<?> value) {
        return ((ServerWorld)this.getWorld()).offer(this.getBlockPosition(), value);
    }

    @Override
    public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, es -> {
            es.add(element);
            return es;
        });
    }

    @Override
    public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> key, K valueKey, V value) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, es -> {
            es.put(valueKey, value);
            return es;
        });
    }

    @Override
    public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, es -> {
            es.putAll(map);
            return es;
        });
    }

    @Override
    public DataTransactionResult offerAll(MapValue<?, ?> value) {
        return ((ServerWorld)this.getWorld()).offer(this.getBlockPosition(), value);
    }

    @Override
    public DataTransactionResult offerAll(CollectionValue<?, ?> value) {
        return ((ServerWorld)this.getWorld()).offer(this.getBlockPosition(), value);
    }

    @Override
    public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return ((ServerWorld)this.getWorld()).offer(this.getBlockPosition(), key, elements);
    }

    @Override
    public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, col -> {
            col.remove(element);
            return col;
        });
    }

    @Override
    public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> key, K mapKey) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, map -> {
            map.remove(mapKey);
            return map;
        });
    }

    @Override
    public DataTransactionResult removeAll(CollectionValue<?, ?> value) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), value.getKey(), col -> {
            col.removeAll((Collection<?>)value.getAll());
            return col;
        });
    }

    @Override
    public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, col -> {
            col.removeAll(elements);
            return col;
        });
    }

    @Override
    public DataTransactionResult removeAll(MapValue<?, ?> value) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), value.getKey(), map -> {
            value.keySet().forEach(map::remove);
            return map;
        });
    }

    @Override
    public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return ((ServerWorld)this.getWorld()).transform(this.getBlockPosition(), key, ex -> {
            map.keySet().forEach(ex::remove);
            return ex;
        });
    }

    @Override
    public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> key, E value) {
        DataTransactionResult result = this.offer(key, value);
        if (!result.isSuccessful()) {
            throw new IllegalArgumentException("Failed offer transaction!");
        }
        return result;
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        return ((ServerWorld)this.getWorld()).remove(this.getBlockPosition(), key);
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        return ((ServerWorld)this.getWorld()).undo(this.getBlockPosition(), result);
    }

    @Override
    public DataTransactionResult copyFrom(ValueContainer that, MergeFunction function) {
        return ((ServerWorld)this.getWorld()).copyFrom(this.getBlockPosition(), that, function);
    }

    @Override
    public <E> Optional<E> get(Direction direction, Key<? extends Value<E>> key) {
        return ((ServerWorld)this.getWorld()).get(this.getBlockPosition(), key);
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return ((ServerWorld)this.getWorld()).get(this.getBlockPosition(), key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return ((ServerWorld)this.getWorld()).getValue(this.getBlockPosition(), key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return ((ServerWorld)this.getWorld()).supports(this.getBlockPosition(), key);
    }

    @Override
    public boolean supports(Supplier<? extends Key<?>> key) {
        return ((ServerWorld)this.getWorld()).supports(this.getBlockPosition(), key);
    }

    @Override
    public Set<Key<?>> getKeys() {
        return ((ServerWorld)this.getWorld()).getKeys(this.getBlockPosition());
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return ((ServerWorld)this.getWorld()).getValues(this.getBlockPosition());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeLocation that = (SpongeLocation)o;
        return this.worldRef.equals(that.worldRef) && this.getPosition().equals((Object)that.getPosition()) && this.getBlockPosition().equals((Object)that.getBlockPosition());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.worldRef, this.getPosition(), this.getBlockPosition());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpongeServerLocation.class.getSimpleName() + "[", "]").add("worldRef=" + this.getWorldKey()).add("position=" + this.getPosition()).toString();
    }

    @Override
    public BlockPos bridge$getBlockPos() {
        return this.posSupplier.get();
    }

    public static final class Factory
    implements ServerLocation.Factory {
        @Override
        public ServerLocation create(ServerWorld world, Vector3d position) {
            Objects.requireNonNull(world);
            Objects.requireNonNull(position);
            return new SpongeServerLocation(world, world.getEngine().getChunkLayout(), position);
        }

        @Override
        public ServerLocation create(ServerWorld world, Vector3i blockPosition) {
            Objects.requireNonNull(world);
            Objects.requireNonNull(blockPosition);
            ChunkLayout chunkLayout = world.getEngine().getChunkLayout();
            Vector3d position = blockPosition.toDouble();
            return new SpongeServerLocation(world, chunkLayout, position);
        }

        @Override
        public ServerLocation create(ResourceKey worldKey, Vector3d position) {
            Objects.requireNonNull(worldKey);
            Objects.requireNonNull(position);
            Optional<ServerWorld> world = Sponge.getServer().getWorldManager().getWorld(worldKey);
            if (!world.isPresent()) {
                throw new IllegalStateException("Unknown world for key: " + worldKey.toString());
            }
            return new SpongeServerLocation(world.get(), world.get().getEngine().getChunkLayout(), position);
        }

        @Override
        public ServerLocation create(ResourceKey worldKey, Vector3i blockPosition) {
            Objects.requireNonNull(worldKey);
            Objects.requireNonNull(blockPosition);
            Optional<ServerWorld> world = Sponge.getServer().getWorldManager().getWorld(worldKey);
            if (!world.isPresent()) {
                throw new IllegalStateException("Unknown world for key: " + worldKey.toString());
            }
            return new SpongeServerLocation(world.get(), world.get().getEngine().getChunkLayout(), blockPosition.toDouble());
        }
    }
}

