/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.base.Preconditions;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.common.util.SpongeCatalogBuilder;
import org.spongepowered.common.world.biome.SpongeVirtualBiomeType;

public class SpongeVirtualBiomeTypeBuilder
extends SpongeCatalogBuilder<VirtualBiomeType, VirtualBiomeType.Builder>
implements VirtualBiomeType.Builder {
    private double temperature;
    private double humidity;
    private BiomeType persisted;

    public SpongeVirtualBiomeTypeBuilder() {
        this.reset();
    }

    @Override
    public VirtualBiomeType.Builder temperature(double temp) {
        this.temperature = temp;
        return this;
    }

    @Override
    public VirtualBiomeType.Builder humidity(double humidity) {
        this.humidity = humidity;
        return this;
    }

    @Override
    public VirtualBiomeType.Builder persistedType(BiomeType biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"biome");
        Preconditions.checkArgument((!(biome instanceof VirtualBiomeType) ? 1 : 0) != 0, (Object)"persisted type cannot be a virtual biome");
        this.persisted = biome;
        return this;
    }

    @Override
    protected VirtualBiomeType build(ResourceKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)this.persisted, (Object)"persistedBiome");
        return new SpongeVirtualBiomeType(this.key, this.temperature, this.humidity, this.persisted);
    }

    @Override
    public VirtualBiomeType.Builder reset() {
        super.reset();
        this.temperature = 0.0;
        this.humidity = 0.0;
        this.persisted = BiomeTypes.VOID.get();
        return this;
    }
}

