/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.border;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SWorldBorderPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public final class PlayerBorderListener
implements IBorderListener {
    private final int dimensionId;
    private final MinecraftServer server;

    public PlayerBorderListener(MinecraftServer server, int dimensionId) {
        this.server = server;
        this.dimensionId = dimensionId;
    }

    public void onSizeChanged(WorldBorder border, double newSize) {
        this.sendBorderPacket((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_SIZE));
    }

    public void onTransitionStarted(WorldBorder border, double oldSize, double newSize, long time) {
        this.sendBorderPacket((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.LERP_SIZE));
    }

    public void onCenterChanged(WorldBorder border, double x, double z) {
        this.sendBorderPacket((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_CENTER));
    }

    public void onWarningTimeChanged(WorldBorder border, int newTime) {
        this.sendBorderPacket((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_WARNING_TIME));
    }

    public void onWarningDistanceChanged(WorldBorder border, int newDistance) {
        this.sendBorderPacket((IPacket<?>)new SWorldBorderPacket(border, SWorldBorderPacket.Action.SET_WARNING_BLOCKS));
    }

    public void onDamageAmountChanged(WorldBorder border, double newAmount) {
    }

    public void onDamageBufferChanged(WorldBorder border, double newSize) {
    }

    private void sendBorderPacket(IPacket<?> packet) {
        for (ServerPlayerEntity player : this.server.getPlayerList().getPlayers()) {
            if (player.dimension.getId() != this.dimensionId || ((ServerPlayer)player).getWorldBorder().isPresent()) continue;
            player.connection.sendPacket(packet);
        }
    }
}

