/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.dimension;

import com.google.common.base.Preconditions;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.common.SpongeCatalogType;

public final class SpongeDimensionType
extends SpongeCatalogType
implements DimensionType {
    private final Context context;
    private final Supplier<BiFunction<World, net.minecraft.world.dimension.DimensionType, ? extends Dimension>> dimensionFactory;
    private final BooleanSupplier hasSkyLight;

    public SpongeDimensionType(ResourceKey key, Supplier<BiFunction<World, net.minecraft.world.dimension.DimensionType, ? extends Dimension>> dimensionFactory, BooleanSupplier hasSkyLight) {
        super(key);
        Preconditions.checkNotNull(dimensionFactory);
        Preconditions.checkNotNull((Object)hasSkyLight);
        this.context = new Context("dimension", key.getNamespace() + "." + key.getValue());
        this.dimensionFactory = dimensionFactory;
        this.hasSkyLight = hasSkyLight;
    }

    @Override
    public boolean hasSkylight() {
        return this.hasSkyLight.getAsBoolean();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public BiFunction<World, net.minecraft.world.dimension.DimensionType, ? extends Dimension> getDimensionFactory() {
        return this.dimensionFactory.get();
    }
}

