/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.player.ServerPlayerEntityAccessor;
import org.spongepowered.common.bridge.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.dimension.PlatformDimensionBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.NetherPortalType;
import org.spongepowered.math.vector.Vector3d;

public final class PortalHelper {
    private static final BlockState northEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.getDefaultState().with((IProperty)EndPortalFrameBlock.FACING, (Comparable)Direction.NORTH);
    private static final BlockState southEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.getDefaultState().with((IProperty)EndPortalFrameBlock.FACING, (Comparable)Direction.SOUTH);
    private static final BlockState eastEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.getDefaultState().with((IProperty)EndPortalFrameBlock.FACING, (Comparable)Direction.EAST);
    private static final BlockState westEndFrame = (BlockState)Blocks.END_PORTAL_FRAME.getDefaultState().with((IProperty)EndPortalFrameBlock.FACING, (Comparable)Direction.WEST);
    private static final BlockState endPortal = Blocks.END_PORTAL.getDefaultState();

    public static void generateEndPortal(net.minecraft.world.server.ServerWorld world, int x, int y, int z, boolean placePortalBlocks) {
        BlockPos.Mutable origin = new BlockPos.Mutable(x, y, z);
        for (int bx = 0; bx < 5; ++bx) {
            for (int by = 0; by < 5; ++by) {
                origin.setPos(x + bx, y, z + by);
                if (bx == 0 && by > 0 && by < 4) {
                    world.setBlockState((BlockPos)origin, (BlockState)southEndFrame.with((IProperty)EndPortalFrameBlock.EYE, (Comparable)Boolean.valueOf(world.rand.nextFloat() > 0.9f)), 2);
                    continue;
                }
                if (bx == 1 || bx == 2 || bx == 3) {
                    if (by == 0) {
                        world.setBlockState((BlockPos)origin, (BlockState)eastEndFrame.with((IProperty)EndPortalFrameBlock.EYE, (Comparable)Boolean.valueOf(world.rand.nextFloat() > 0.9f)), 2);
                        continue;
                    }
                    if (by == 4) {
                        world.setBlockState((BlockPos)origin, (BlockState)westEndFrame.with((IProperty)EndPortalFrameBlock.EYE, (Comparable)Boolean.valueOf(world.rand.nextFloat() > 0.9f)), 2);
                        continue;
                    }
                    if (!placePortalBlocks) continue;
                    world.setBlockState((BlockPos)origin, endPortal, 2);
                    continue;
                }
                if (bx != 4 || by <= 0 || by >= 4) continue;
                world.setBlockState((BlockPos)origin, (BlockState)northEndFrame.with((IProperty)EndPortalFrameBlock.EYE, (Comparable)Boolean.valueOf(world.rand.nextFloat() > 0.9f)), 2);
            }
        }
    }

    public static void generateNetherPortal(net.minecraft.world.server.ServerWorld world, int x, int y, int z, boolean placePortalBlocks) {
        int i = 16;
        double d0 = -1.0;
        int j = x;
        int k = y;
        int l = z;
        int i1 = j;
        int j1 = k;
        int k1 = l;
        int l1 = 0;
        int i2 = world.rand.nextInt(4);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int j2 = j - 16; j2 <= j + 16; ++j2) {
            double d1 = (double)j2 + 0.5 - (double)x;
            for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                double d2 = (double)l2 + 0.5 - (double)z;
                block2: for (int j3 = world.getActualHeight() - 1; j3 >= 0; --j3) {
                    if (!world.isAirBlock((BlockPos)blockpos$mutable.setPos(j2, j3, l2))) continue;
                    while (j3 > 0 && world.isAirBlock((BlockPos)blockpos$mutable.setPos(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutable.setPos(i5, j5, k5);
                                    if (l4 < 0 && !world.getBlockState((BlockPos)blockpos$mutable).getMaterial().isSolid() || l4 >= 0 && !world.isAirBlock((BlockPos)blockpos$mutable)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - (double)y;
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                double d3 = (double)l5 + 0.5 - (double)x;
                for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                    double d4 = (double)j6 + 0.5 - (double)z;
                    block10: for (int i7 = world.getActualHeight() - 1; i7 >= 0; --i7) {
                        if (!world.isAirBlock((BlockPos)blockpos$mutable.setPos(l5, i7, j6))) continue;
                        while (i7 > 0 && world.isAirBlock((BlockPos)blockpos$mutable.setPos(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int l7 = i2; l7 < i2 + 2; ++l7) {
                            int l8 = l7 % 2;
                            int k9 = 1 - l8;
                            for (int i10 = 0; i10 < 4; ++i10) {
                                for (int k10 = -1; k10 < 4; ++k10) {
                                    int i11 = l5 + (i10 - 1) * l8;
                                    int j11 = i7 + k10;
                                    int k11 = j6 + (i10 - 1) * k9;
                                    blockpos$mutable.setPos(i11, j11, k11);
                                    if (k10 < 0 && !world.getBlockState((BlockPos)blockpos$mutable).getMaterial().isSolid() || k10 >= 0 && !world.isAirBlock((BlockPos)blockpos$mutable)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - (double)y;
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                            l1 = l7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.clamp((int)j1, (int)70, (int)(world.getActualHeight() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int i8 = 1; i8 < 3; ++i8) {
                    for (int i9 = -1; i9 < 3; ++i9) {
                        int l9 = i6 + (i8 - 1) * l6 + j7 * i3;
                        int j10 = k2 + i9;
                        int l10 = k6 + (i8 - 1) * i3 - j7 * l6;
                        boolean flag = i9 < 0;
                        blockpos$mutable.setPos(l9, j10, l10);
                        world.setBlockState((BlockPos)blockpos$mutable, flag ? Blocks.OBSIDIAN.getDefaultState() : Blocks.AIR.getDefaultState());
                    }
                }
            }
        }
        for (int k7 = -1; k7 < 3; ++k7) {
            for (int j8 = -1; j8 < 4; ++j8) {
                if (k7 != -1 && k7 != 2 && j8 != -1 && j8 != 3) continue;
                blockpos$mutable.setPos(i6 + k7 * l6, k2 + j8, k6 + k7 * i3);
                world.setBlockState((BlockPos)blockpos$mutable, Blocks.OBSIDIAN.getDefaultState(), 3);
            }
        }
        if (placePortalBlocks) {
            BlockState blockstate = (BlockState)Blocks.NETHER_PORTAL.getDefaultState().with((IProperty)NetherPortalBlock.AXIS, (Comparable)(l6 == 0 ? Direction.Axis.Z : Direction.Axis.X));
            for (int k8 = 0; k8 < 2; ++k8) {
                for (int j9 = 0; j9 < 3; ++j9) {
                    blockpos$mutable.setPos(i6 + k8 * l6, k2 + j9, k6 + k8 * i3);
                    world.setBlockState((BlockPos)blockpos$mutable, blockstate, 18);
                }
            }
        }
    }

    public static void generateEndObsidianPlatform(net.minecraft.world.server.ServerWorld world, int x, int y, int z) {
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -1; l1 < 3; ++l1) {
                    int i2 = x + k1 * 1 + j1 * 0;
                    int j2 = y - 1 + l1;
                    int k2 = z + k1 * 0 - j1 * 1;
                    boolean flag = l1 < 0;
                    world.setBlockState(new BlockPos(i2, j2, k2), flag ? Blocks.OBSIDIAN.getDefaultState() : Blocks.AIR.getDefaultState());
                }
            }
        }
    }

    public static Function<Boolean, Entity> createVanillaEntityPortalLogic(Entity entity, Vec3d destination, net.minecraft.world.server.ServerWorld fromWorld, net.minecraft.world.server.ServerWorld toWorld, PortalType portal) {
        return spawnInPortal -> {
            double x = destination.x;
            double y = destination.y;
            double z = destination.z;
            float pitch = entity.rotationPitch;
            float yaw = entity.rotationYaw;
            Vec3d motion = entity.getMotion();
            fromWorld.getProfiler().startSection("moving");
            if (!(portal instanceof NetherPortalType) && fromWorld.getDimension().getType() == DimensionType.THE_END && toWorld.getDimension().getType() == DimensionType.OVERWORLD) {
                BlockPos pos = toWorld.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, toWorld.getSpawnPoint());
                x = pos.getX();
                y = pos.getY();
                z = pos.getZ();
            } else if (!(portal instanceof NetherPortalType) && toWorld.getDimension() instanceof EndDimension) {
                BlockPos blockpos = toWorld.getSpawnCoordinate();
                x = blockpos.getX();
                y = blockpos.getY();
                z = blockpos.getZ();
                yaw = 90.0f;
                pitch = 0.0f;
            } else {
                double moveFactor = ((PlatformDimensionBridge)fromWorld.getDimension()).bridge$getMovementFactor() / ((PlatformDimensionBridge)toWorld.getDimension()).bridge$getMovementFactor();
                x *= moveFactor;
                z *= moveFactor;
            }
            toWorld.getProfiler().endSection();
            toWorld.getProfiler().startSection("placing");
            double d7 = Math.min(-2.9999872E7, toWorld.getWorldBorder().minX() + 16.0);
            double d4 = Math.min(-2.9999872E7, toWorld.getWorldBorder().minZ() + 16.0);
            double d5 = Math.min(2.9999872E7, toWorld.getWorldBorder().maxX() - 16.0);
            double d6 = Math.min(2.9999872E7, toWorld.getWorldBorder().maxZ() - 16.0);
            x = MathHelper.clamp((double)x, (double)d7, (double)d5);
            z = MathHelper.clamp((double)z, (double)d4, (double)d6);
            if (fromWorld.getDimension().getType() == DimensionType.THE_END && toWorld.getDimension().getType() == DimensionType.OVERWORLD) {
                spawnInPortal = false;
            }
            if (toWorld.getDimension().getType() == DimensionType.THE_END) {
                spawnInPortal = false;
            }
            boolean isPortalThere = false;
            if (portal instanceof NetherPortalType || spawnInPortal.booleanValue()) {
                BlockPattern.PortalInfo result = toWorld.getDefaultTeleporter().placeInExistingPortal(new BlockPos(x, y, z), motion, entity.getTeleportDirection(), entity.getLastPortalVec().x, entity.getLastPortalVec().y, false);
                if (result == null) {
                    isPortalThere = false;
                } else {
                    isPortalThere = true;
                    x = result.pos.x;
                    y = result.pos.y;
                    z = result.pos.z;
                    motion = result.motion;
                    yaw = result.rotation;
                }
            }
            if (spawnInPortal.booleanValue() && !isPortalThere) {
                return entity;
            }
            ChangeEntityWorldEvent.Reposition event = SpongeEventFactory.createChangeEntityWorldEventReposition(PhaseTracker.getCauseStackManager().getCurrentCause(), (org.spongepowered.api.entity.Entity)entity, (ServerWorld)fromWorld, VecHelper.toVector3d(entity.getPositionVector()), new Vector3d(x, y, z), (ServerWorld)toWorld, new Vector3d(x, y, z), (ServerWorld)toWorld);
            if (SpongeCommon.postEvent(event)) {
                entity.setMotion(Vec3d.ZERO);
                return entity;
            }
            x = event.getDestinationPosition().getX();
            y = event.getDestinationPosition().getY();
            z = event.getDestinationPosition().getZ();
            ((PlatformEntityBridge)entity).bridge$remove(true);
            Entity result = entity.getType().create((World)toWorld);
            if (result != null) {
                result.copyDataFromOld(entity);
                result.moveToBlockPosAndAngles(new BlockPos(x, y, z), yaw, pitch);
                result.setMotion(motion);
                toWorld.addFromAnotherDimension(result);
            }
            return result;
        };
    }

    public static Function<Boolean, Entity> createVanillaPlayerPortalLogic(ServerPlayerEntity player, Vec3d destination, net.minecraft.world.server.ServerWorld fromWorld, net.minecraft.world.server.ServerWorld toWorld, PortalType portal) {
        return spawnInPortal -> {
            ChangeEntityWorldEvent.Reposition event;
            boolean isSameWorld;
            float originalYaw;
            double x = destination.x;
            double y = destination.y;
            double z = destination.z;
            float pitch = player.rotationPitch;
            float yaw = originalYaw = player.rotationYaw;
            fromWorld.getProfiler().startSection("moving");
            boolean bl = isSameWorld = fromWorld == toWorld;
            if (!(portal instanceof NetherPortalType) && fromWorld.getDimension().getType() == DimensionType.THE_END && toWorld.getDimension().getType() == DimensionType.OVERWORLD) {
                BlockPos pos = toWorld.getHeight(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, toWorld.getSpawnPoint());
                x = pos.getX();
                y = pos.getY();
                z = pos.getZ();
            } else if (!(portal instanceof NetherPortalType) && toWorld.getDimension() instanceof EndDimension) {
                BlockPos blockpos = toWorld.getSpawnCoordinate();
                x = blockpos.getX();
                y = blockpos.getY();
                z = blockpos.getZ();
                yaw = 90.0f;
                pitch = 0.0f;
            } else {
                double moveFactor = ((PlatformDimensionBridge)fromWorld.getDimension()).bridge$getMovementFactor() / ((PlatformDimensionBridge)toWorld.getDimension()).bridge$getMovementFactor();
                x *= moveFactor;
                z *= moveFactor;
            }
            fromWorld.getProfiler().endSection();
            fromWorld.getProfiler().startSection("placing");
            double d7 = Math.min(-2.9999872E7, toWorld.getWorldBorder().minX() + 16.0);
            double d4 = Math.min(-2.9999872E7, toWorld.getWorldBorder().minZ() + 16.0);
            double d5 = Math.min(2.9999872E7, toWorld.getWorldBorder().maxX() - 16.0);
            double d6 = Math.min(2.9999872E7, toWorld.getWorldBorder().maxZ() - 16.0);
            x = MathHelper.clamp((double)x, (double)d7, (double)d5);
            z = MathHelper.clamp((double)z, (double)d4, (double)d6);
            if (fromWorld.getDimension().getType() == DimensionType.THE_END && toWorld.getDimension().getType() == DimensionType.OVERWORLD) {
                spawnInPortal = false;
            }
            if (toWorld.getDimension().getType() == DimensionType.THE_END) {
                spawnInPortal = false;
            }
            if (portal instanceof NetherPortalType) {
                spawnInPortal = true;
            }
            ((ServerPlayerEntityBridge)player).bridge$sendChangeDimension(toWorld.dimension.getType(), WorldInfo.byHashing((long)toWorld.getSeed()), toWorld.getWorldType(), player.interactionManager.getGameType());
            boolean isPortalThere = false;
            if (spawnInPortal.booleanValue()) {
                BlockPattern.PortalInfo result = toWorld.getDefaultTeleporter().placeInExistingPortal(new BlockPos(x, y, z), player.getMotion(), player.getTeleportDirection(), player.getLastPortalVec().x, player.getLastPortalVec().y, true);
                if (result == null) {
                    isPortalThere = false;
                } else {
                    isPortalThere = true;
                    x = result.pos.x;
                    y = result.pos.y;
                    z = result.pos.z;
                    yaw = result.rotation;
                }
            }
            if (SpongeCommon.postEvent(event = SpongeEventFactory.createChangeEntityWorldEventReposition(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerPlayer)player, (ServerWorld)fromWorld, VecHelper.toVector3d(player.getPositionVector()), new Vector3d(x, y, z), (ServerWorld)toWorld, new Vector3d(x, y, z), (ServerWorld)toWorld))) {
                player.connection.setPlayerLocation(player.getPosX(), player.getPosY(), player.getPosZ(), player.rotationYaw, player.rotationPitch);
                player.connection.captureCurrentPosition();
                player.setMotion(Vec3d.ZERO);
                return player;
            }
            x = event.getDestinationPosition().getX();
            y = event.getDestinationPosition().getY();
            z = event.getDestinationPosition().getZ();
            if (!isSameWorld && !(portal instanceof NetherPortalType) && toWorld.getDimension() instanceof EndDimension) {
                PortalHelper.generateEndObsidianPlatform(toWorld, (int)x, (int)y, (int)z);
                player.setMotion(Vec3d.ZERO);
            } else if (spawnInPortal.booleanValue() && !isSameWorld && !(portal instanceof NetherPortalType) && toWorld.getDimension().getType() == DimensionType.THE_NETHER) {
                ((ServerPlayerEntityAccessor)player).accessor$setEnteredNetherPosition(player.getPositionVec());
            }
            if (spawnInPortal.booleanValue() && !isPortalThere) {
                player.setLocationAndAngles(x, y, z, originalYaw, pitch);
                toWorld.getDefaultTeleporter().makePortal((Entity)player);
                toWorld.getDefaultTeleporter().placeInPortal((Entity)player, yaw);
                x = player.getPosX();
                y = player.getPosY();
                z = player.getPosZ();
                yaw = player.rotationYaw;
                pitch = player.rotationPitch;
            }
            player.connection.setPlayerLocation(x, y, z, yaw, pitch);
            player.connection.captureCurrentPosition();
            fromWorld.getProfiler().endSection();
            return player;
        };
    }
}

