/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.volume.biome.MutableBiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements MutableBiomeVolume<ObjectArrayMutableBiomeBuffer> {
    private final BiomeType[] biomes;

    public ObjectArrayMutableBiomeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = new BiomeType[size.getX() * size.getY() * size.getZ()];
        Arrays.fill(this.biomes, BiomeTypes.OCEAN);
    }

    public ObjectArrayMutableBiomeBuffer(BiomeType[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, y, z)];
    }

    public Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        BiomeType type = this.biomes[this.getIndex(x, y, z)];
        if (type instanceof VirtualBiomeType) {
            type = ((VirtualBiomeType)type).getPersistedType();
        }
        return (Biome)type;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        Objects.requireNonNull(biome, "biome");
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)y, (int)z)] = biome;
        return true;
    }

    public boolean setBiome(BlockPos pos, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        Objects.requireNonNull(pos, "pos");
        this.checkRange(pos.getX(), pos.getY(), pos.getZ());
        this.biomes[this.getIndex((int)pos.getX(), (int)pos.getY(), (int)pos.getZ())] = (BiomeType)biome;
        return true;
    }

    public void fill(int[] biomes) {
        for (int x = 0; x < this.size.getX(); ++x) {
            for (int z = 0; z < this.size.getZ(); ++z) {
                BiomeType type = this.biomes[x + z * this.size.getX()];
                if (type instanceof VirtualBiomeType) {
                    type = ((VirtualBiomeType)type).getPersistedType();
                }
                biomes[x + z * this.size.getX()] = Registry.BIOME.getId((Object)((Biome)type));
            }
        }
    }

    public void fill(Biome[] biomes) {
        for (int x = 0; x < this.size.getX(); ++x) {
            for (int z = 0; z < this.size.getZ(); ++z) {
                BiomeType type = this.biomes[x + z * this.size.getX()];
                if (type instanceof VirtualBiomeType) {
                    type = ((VirtualBiomeType)type).getPersistedType();
                }
                biomes[x + z * this.size.getX()] = (Biome)type;
            }
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayMutableBiomeBuffer that = (ObjectArrayMutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<ObjectArrayMutableBiomeBuffer, BiomeType> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        BiomeType[] buffer = options.carbonCopy() ? Arrays.copyOf(this.biomes, this.biomes.length) : this.biomes;
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer[this.getIndex(x, y, z)], new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ObjectArrayMutableBiomeBuffer, BiomeType>(stateStream, () -> this);
    }
}

