/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.block;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.block.MutableBlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.math.vector.Vector3i;

public class ArrayMutableBlockBuffer
extends AbstractBlockBuffer
implements MutableBlockVolume<ArrayMutableBlockBuffer> {
    private static final int SMALL_AREA_THRESHOLD = 256;
    private static final BlockState AIR = (BlockState)BlockTypes.AIR.get().getDefaultState();
    private Palette.Mutable<BlockState> palette;
    private BackingData data;

    public ArrayMutableBlockBuffer(Vector3i start, Vector3i size) {
        this((Palette<BlockState>)(size.getX() * size.getY() * size.getZ() > 256 ? new MutableBimapPalette<BlockState>(PaletteTypes.BLOCK_STATE_PALETTE.get()) : GlobalPalette.getBlockPalette()), start, size);
    }

    public ArrayMutableBlockBuffer(Palette<BlockState> palette, Vector3i start, Vector3i size) {
        super(start, size);
        Palette.Mutable<BlockState> mutablePalette = palette.asMutable();
        this.palette = mutablePalette;
        int airId = mutablePalette.getOrAssign(AIR);
        int dataSize = this.area();
        this.data = new PackedBackingData(dataSize, palette.getHighestId());
        if (airId != 0) {
            for (int i = 0; i < dataSize; ++i) {
                this.data.set(i, airId);
            }
        }
    }

    public ArrayMutableBlockBuffer(Palette<BlockState> palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.palette = palette.asMutable();
        this.data = new CharBackingData(blocks);
    }

    ArrayMutableBlockBuffer(Palette<BlockState> palette, BackingData blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.palette = palette.asMutable();
        this.data = blocks;
    }

    @Override
    public Palette<BlockState> getPalette() {
        return this.palette;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkRange(x, y, z);
        int id = this.palette.getOrAssign(block);
        if (id > this.data.getMax()) {
            PackedBackingData newdata;
            int highId = this.palette.getHighestId();
            int dataSize = this.area();
            if (highId * 2 > GlobalPalette.getBlockPalette().getHighestId()) {
                Palette.Mutable<BlockState> newpalette = GlobalPalette.getBlockPalette().asMutable();
                id = newpalette.getOrAssign(block);
                highId = newpalette.getHighestId();
                newdata = new PackedBackingData(dataSize, highId);
                for (int i = 0; i < dataSize; ++i) {
                    newdata.set(i, newpalette.getOrAssign(this.palette.get(this.data.get(i)).orElse(AIR)));
                }
                this.palette = newpalette;
            } else {
                newdata = new PackedBackingData(dataSize, highId);
                for (int i = 0; i < dataSize; ++i) {
                    newdata.set(i, this.data.get(i));
                }
            }
            this.data = newdata;
        }
        this.data.set(this.getIndex(x, y, z), id);
        return true;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.setBlock(x, y, z, (BlockState)BlockTypes.AIR.get().getDefaultState());
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.palette.get(this.data.get(this.getIndex(x, y, z))).orElse(AIR);
    }

    @Override
    public FluidState getFluid(int x, int y, int z) {
        return this.getBlock(x, y, z).getFluidState();
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return 0;
    }

    private int area() {
        return this.size.getX() * this.size.getY() * this.size.getZ();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayMutableBlockBuffer that = (ArrayMutableBlockBuffer)o;
        return this.palette.equals(that.palette) && this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.palette, this.data);
    }

    @Override
    public VolumeStream<ArrayMutableBlockBuffer, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size) : this;
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer.getBlock(x, y, z), new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ArrayMutableBlockBuffer, BlockState>(stateStream, () -> this);
    }

    public void setBlock(BlockPos pos, net.minecraft.block.BlockState blockState) {
        this.setBlock(pos.getX(), pos.getY(), pos.getZ(), (BlockState)blockState);
    }

    public net.minecraft.block.BlockState getBlock(BlockPos blockPos) {
        return (net.minecraft.block.BlockState)this.getBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public ArrayMutableBlockBuffer copy() {
        return new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size);
    }

    static class PackedBackingData
    implements BackingData {
        private final long[] longArray;
        private final int bits;
        private final long maxValue;
        private final int arraySize;

        public PackedBackingData(int size, int highestValue) {
            this.arraySize = size;
            int bits = 0;
            while (1 << bits <= highestValue) {
                ++bits;
            }
            this.bits = bits;
            this.maxValue = (1 << bits) - 1;
            this.longArray = new long[MathHelper.roundUp((int)(size * bits), (int)64) / 64];
        }

        private PackedBackingData(int size, int bits, long[] array) {
            this.arraySize = size;
            this.bits = bits;
            this.maxValue = (1 << bits) - 1;
            this.longArray = array;
        }

        @Override
        public void set(int index, int value) {
            int bitIndex = index * this.bits;
            int longIndex = bitIndex / 64;
            int bitOffset = bitIndex % 64;
            this.longArray[longIndex] = this.longArray[longIndex] & (this.maxValue << bitOffset ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << bitOffset;
            if (bitOffset + this.bits > 64) {
                int bitsInLeft = 64 - bitOffset;
                int bitsInRight = this.bits - bitsInLeft;
                this.longArray[++longIndex] = this.longArray[longIndex] >>> bitsInRight << bitsInRight | (long)value >> bitsInLeft;
            }
        }

        @Override
        public int get(int index) {
            int bitIndex = index * this.bits;
            int longIndex = bitIndex / 64;
            int rightLongIndex = (bitIndex + this.bits - 1) / 64;
            int bitOffset = bitIndex % 64;
            if (bitOffset + this.bits > 64) {
                int bitsInLeft = 64 - bitOffset;
                return (int)((this.longArray[longIndex] >>> bitOffset | this.longArray[rightLongIndex] << bitsInLeft) & this.maxValue);
            }
            return (int)(this.longArray[longIndex] >>> bitOffset & this.maxValue);
        }

        @Override
        public PackedBackingData copyOf() {
            return new PackedBackingData(this.arraySize, this.bits, (long[])this.longArray.clone());
        }

        @Override
        public int getMax() {
            return (int)this.maxValue;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackedBackingData that = (PackedBackingData)o;
            return this.bits == that.bits && this.maxValue == that.maxValue && this.arraySize == that.arraySize && Arrays.equals(this.longArray, that.longArray);
        }

        public int hashCode() {
            int result = Objects.hash(this.bits, this.maxValue, this.arraySize);
            result = 31 * result + Arrays.hashCode(this.longArray);
            return result;
        }
    }

    static class CharBackingData
    implements BackingData {
        private final char[] data;

        public CharBackingData(char[] data) {
            this.data = data;
        }

        @Override
        public int get(int index) {
            return this.data[index];
        }

        @Override
        public void set(int index, int val) {
            this.data[index] = (char)val;
        }

        @Override
        public BackingData copyOf() {
            return new CharBackingData((char[])this.data.clone());
        }

        @Override
        public int getMax() {
            return 65535;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharBackingData that = (CharBackingData)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    static interface BackingData {
        public int get(int var1);

        public void set(int var1, int var2);

        public BackingData copyOf();

        public int getMax();
    }
}

