/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.handler;

import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.jvm.locator.ResourceType;
import org.spongepowered.vanilla.applaunch.Main;

public abstract class AbstractVanillaLaunchHandler
implements ILaunchHandlerService {
    protected final Logger logger = LogManager.getLogger("Launch");
    protected static final List<String> EXCLUDED_PACKAGES = Arrays.asList("org.spongepowered.plugin.", "org.spongepowered.common.applaunch.", "org.spongepowered.vanilla.applaunch.", "io.leangen.geantyref.", "org.spongepowered.configurate.");
    protected static final List<String> EXCLUDED_EXCEPTIONS = Arrays.asList("org.spongepowered.configurate.objectmapping.guice.");

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
        builder.setClassBytesLocator(this.getResourceLocator());
    }

    public Callable<Void> launchService(String[] arguments, ITransformingClassLoader launchClassLoader) {
        this.logger.info("Transitioning to Sponge launcher, please wait...");
        launchClassLoader.addTargetPackageFilter(klass -> {
            block0: for (String pkg : EXCLUDED_PACKAGES) {
                if (!klass.startsWith(pkg)) continue;
                for (String bypass : EXCLUDED_EXCEPTIONS) {
                    if (!klass.startsWith(bypass)) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        });
        return () -> {
            this.launchService0(arguments, launchClassLoader);
            return null;
        };
    }

    protected Function<String, Optional<URL>> getResourceLocator() {
        return s2 -> {
            for (Map.Entry<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> serviceCandidates : Main.getInstance().getPluginEngine().getCandidates().entrySet()) {
                for (PluginCandidate<PluginResource> candidate : serviceCandidates.getValue()) {
                    Path resolved;
                    PluginResource resource = candidate.getResource();
                    if (resource instanceof JVMPluginResource && ((JVMPluginResource)resource).getType() != ResourceType.JAR || !Files.exists(resolved = resource.getFileSystem().getPath((String)s2, new String[0]), new LinkOption[0])) continue;
                    try {
                        return Optional.of(resolved.toUri().toURL());
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            return Optional.empty();
        };
    }

    protected abstract void launchService0(String[] var1, ITransformingClassLoader var2) throws Exception;
}

