/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.accesstransformer.AccessTransformerEngine;
import org.spongepowered.plugin.PluginKeys;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.vanilla.applaunch.Main;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginEngine;

public final class VanillaPlatformService
implements ITransformationService {
    private static final String NAME = "vanilla_platform";
    private static final VanillaPluginEngine pluginEngine = Main.getInstance().getPluginEngine();

    @Nonnull
    public String name() {
        return NAME;
    }

    public void initialize(IEnvironment environment) {
        Main.getInstance().getPluginEngine().initialize();
    }

    public void beginScanning(IEnvironment environment) {
    }

    public List<Map.Entry<String, Path>> runScan(IEnvironment environment) {
        pluginEngine.locatePluginResources();
        pluginEngine.createPluginCandidates();
        ArrayList<Map.Entry<String, Path>> launchResources = new ArrayList<Map.Entry<String, Path>>();
        for (Map.Entry<String, List<PluginResource>> resourcesEntry : pluginEngine.getResources().entrySet()) {
            List<PluginResource> resources = resourcesEntry.getValue();
            for (PluginResource resource : resources) {
                if (resource instanceof JVMPluginResource) {
                    ((JVMPluginResource)resource).getManifest().ifPresent(manifest -> {
                        String atFiles = manifest.getMainAttributes().getValue("AT");
                        if (atFiles != null) {
                            for (String atFile : atFiles.split(",")) {
                                if (!atFile.endsWith(".cfg")) continue;
                                AccessTransformerEngine.INSTANCE.addResource(resource.getFileSystem().getPath("META-INF", new String[0]).resolve(atFile), atFile);
                            }
                        }
                    });
                }
                Map.Entry entry = Maps.immutableEntry((Object)resource.getPath().getFileName().toString(), (Object)resource.getPath());
                launchResources.add(entry);
            }
        }
        return launchResources;
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        VanillaPluginEngine pluginEngine = VanillaPlatformService.pluginEngine;
        pluginEngine.getPluginEnvironment().getLogger().info("SpongePowered PLUGIN Subsystem Version={} Source={}", pluginEngine.getPluginEnvironment().getBlackboard().get(PluginKeys.VERSION).get(), (Object)this.getCodeSource());
        pluginEngine.discoverLocatorServices();
        pluginEngine.getLocatorServices().forEach((k, v) -> pluginEngine.getPluginEnvironment().getLogger().info("Plugin resource locator '{}' found.", k));
        pluginEngine.discoverLanguageServices();
        pluginEngine.getLanguageServices().forEach((k, v) -> pluginEngine.getPluginEnvironment().getLogger().info("Plugin language loader '{}' found.", k));
    }

    @Nonnull
    public List<ITransformer> transformers() {
        return ImmutableList.of();
    }

    private String getCodeSource() {
        try {
            return this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable th) {
            return "Unknown";
        }
    }
}

