/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget.list;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.vanilla.util.Bounds;

public class FilterableList<P extends FilterableList<P, E>, E extends Entry<P, E>>
extends AbstractList<E> {
    private final Screen screen;
    private Supplier<List<E>> filterSupplier;
    private Consumer<E> selectConsumer;
    protected final FontRenderer fontRenderer;
    protected E currentHoveredEntry;

    public FilterableList(Screen screen, int x, int y, int width, int height, int entryHeight) {
        super(Minecraft.getInstance(), width, screen.height, y, y + height, entryHeight);
        this.screen = screen;
        this.x0 = x;
        this.x1 = x + width;
        this.fontRenderer = Minecraft.getInstance().fontRenderer;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public int getX() {
        return this.x0;
    }

    public P setX(int x) {
        this.x0 = x;
        return (P)((Object)this);
    }

    public int getY() {
        return this.y0;
    }

    public P setY(int y) {
        this.y0 = y;
        return (P)((Object)this);
    }

    public P setPosition(int x, int y) {
        this.x0 = x;
        this.y0 = y;
        return (P)((Object)this);
    }

    public int getWidth() {
        return this.width;
    }

    public P setWidth(int width) {
        this.width = width;
        return (P)((Object)this);
    }

    public int getHeight() {
        return this.height;
    }

    public P setHeight(int height) {
        this.height = height;
        return (P)((Object)this);
    }

    public P setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return (P)((Object)this);
    }

    public P setBounds(int x, int y, int width, int height) {
        this.x0 = x;
        this.y0 = y;
        this.width = width;
        this.height = height;
        return (P)((Object)this);
    }

    public int getRight() {
        return this.x0 + this.width;
    }

    public int getBottom() {
        return this.y0 + this.headerHeight;
    }

    public E getCurrentHoveredEntry() {
        return this.currentHoveredEntry;
    }

    public P setCurrentHoveredEntry(E currentHoveredEntry) {
        this.currentHoveredEntry = currentHoveredEntry;
        return (P)((Object)this);
    }

    @SafeVarargs
    public final P addEntries(E ... entries) {
        this.addEntries(Arrays.asList(entries));
        return (P)((Object)this);
    }

    public P addEntries(List<E> entries) {
        entries.forEach(arg_0 -> ((FilterableList)this).addEntry(arg_0));
        return (P)((Object)this);
    }

    public Consumer<E> getSelectConsumer() {
        return this.selectConsumer;
    }

    public P setSelectConsumer(Consumer<E> selectConsumer) {
        this.selectConsumer = selectConsumer;
        return (P)((Object)this);
    }

    public Supplier<List<E>> getFilterSupplier() {
        return this.filterSupplier;
    }

    public P setFilterSupplier(Supplier<List<E>> filterSupplier) {
        this.filterSupplier = filterSupplier;
        return (P)((Object)this);
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.getRowTop(p_getRowBottom_1_) + this.itemHeight;
    }

    public int getRowHeight() {
        return this.itemHeight;
    }

    public int getRowWidth() {
        return this.width - 12;
    }

    protected int getRowLeft() {
        return this.x0 + 4;
    }

    protected int getScrollbarPosition() {
        return this.x0 + this.width - 6;
    }

    public void setSelected(@Nullable E entry) {
        if (this.selectConsumer != null) {
            this.selectConsumer.accept(entry);
        }
        super.setSelected(entry);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (!this.isMouseOver(p_mouseClicked_1_, p_mouseClicked_3_)) {
            return false;
        }
        Entry e = (Entry)this.getEntryAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
        if (e != null) {
            if (e.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                this.setFocused((IGuiEventListener)e);
                this.setDragging(true);
                return true;
            }
        } else if (p_mouseClicked_5_ == 0) {
            this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.y0) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return true;
    }

    protected void renderList(int renderX, int renderY, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        Object filteredList = this.filterSupplier == null ? new ObjectArrayList((Collection)this.children()) : this.filterSupplier.get();
        int itemCount = filteredList.size();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        if (filteredList.isEmpty()) {
            FontRenderer font = this.minecraft.fontRenderer;
            String noResults = "No results...";
            int noResultsWidth = font.getStringWidth("No results...");
            font.drawString("No results...", (float)(this.width / 2 + this.x0 - noResultsWidth / 2), (float)(this.y0 + 10), TextFormatting.GRAY.getColor().intValue());
            return;
        }
        for (int i = 0; i < itemCount; ++i) {
            int rowTop = this.getRowTop(i);
            int rowBottom = this.getRowBottom(i);
            if (rowBottom < this.y0 || rowTop > this.y1) continue;
            int yStart = renderY + i * this.itemHeight + this.headerHeight;
            int yEnd = this.itemHeight - 4;
            int rowWidth = this.getRowWidth();
            if (this.renderSelection && Objects.equals(this.getSelected(), filteredList.get(i))) {
                int xSelectStart = this.x0 + this.width / 2 - rowWidth / 2 - 2;
                int xSelectEnd = this.x0 + this.width / 2 + rowWidth / 2 - 4;
                GlStateManager.disableTexture();
                float f = this.isFocused() ? 1.0f : 0.5f;
                GlStateManager.color4f((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.begin(7, DefaultVertexFormats.POSITION);
                bufferbuilder.pos((double)xSelectStart, (double)(yStart + yEnd + 2), 0.0).endVertex();
                bufferbuilder.pos((double)xSelectEnd, (double)(yStart + yEnd + 2), 0.0).endVertex();
                bufferbuilder.pos((double)xSelectEnd, (double)(yStart - 2), 0.0).endVertex();
                bufferbuilder.pos((double)xSelectStart, (double)(yStart - 2), 0.0).endVertex();
                tessellator.draw();
                GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.begin(7, DefaultVertexFormats.POSITION);
                bufferbuilder.pos((double)(xSelectStart + 1), (double)(yStart + yEnd + 1), 0.0).endVertex();
                bufferbuilder.pos((double)(xSelectEnd - 1), (double)(yStart + yEnd + 1), 0.0).endVertex();
                bufferbuilder.pos((double)(xSelectEnd - 1), (double)(yStart - 1), 0.0).endVertex();
                bufferbuilder.pos((double)(xSelectStart + 1), (double)(yStart - 1), 0.0).endVertex();
                tessellator.draw();
                GlStateManager.enableTexture();
            }
            Entry entry = (Entry)((Object)filteredList.get(i));
            entry.render(i, rowTop, this.getRowLeft(), rowWidth, yEnd, p_renderList_3_, p_renderList_4_, false, p_renderList_5_);
        }
    }

    public static abstract class Entry<P extends FilterableList<P, E>, E extends Entry<P, E>>
    extends AbstractList.AbstractListEntry<E> {
        private final P parentList;

        public Entry(P parentList) {
            this.parentList = parentList;
        }

        public P getParentList() {
            return this.parentList;
        }

        public abstract Bounds getInteractBounds();

        public void render(int p_render_1_, int renderY, int renderX, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            if (this.getInteractBounds().isInBounds(mouseX, mouseY, renderX, renderY)) {
                ((FilterableList)((Object)this.parentList)).currentHoveredEntry = this;
            } else if (((FilterableList)((Object)this.parentList)).getCurrentHoveredEntry() == this) {
                ((FilterableList)((Object)this.parentList)).currentHoveredEntry = null;
            }
        }
    }
}

