/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.NodeResolver;
import org.spongepowered.vanilla.installer.LauncherConfig;
import org.spongepowered.vanilla.installer.LibraryManager;

public final class Installer {
    private final Logger logger;
    private final Path directory;
    private final LibraryManager libraryManager;
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private final LauncherConfig config;

    public Installer(Logger logger, Path directory) throws ConfigurateException {
        this.logger = logger;
        this.directory = directory;
        Path launcherConfigFile = this.directory.resolve("launcher.conf");
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(launcherConfigFile)).defaultOptions(options -> options.shouldCopyDefaults(true).implicitInitialization(true).serializers(builder -> builder.registerAnnotatedObjects(ObjectMapper.factoryBuilder().addNodeResolver(NodeResolver.onlyWithSetting()).build())))).build();
        this.config = this.loadConfig();
        this.libraryManager = new LibraryManager(this, Paths.get(this.config.librariesDirectory.replace("${BASE_DIRECTORY}", directory.toAbsolutePath().toString()), new String[0]));
    }

    private LauncherConfig loadConfig() throws ConfigurateException {
        CommentedConfigurationNode node = this.loader.load();
        LauncherConfig ret = node.get(LauncherConfig.class);
        this.loader.save(node);
        return ret;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public LauncherConfig getLauncherConfig() {
        return this.config;
    }
}

