/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.apache.logging.log4j.Logger;

public final class InstallerUtils {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private InstallerUtils() {
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void download(Logger logger, URL url, Path path, boolean requiresRequest) throws IOException {
        block49: {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String name = path.getFileName().toString();
            logger.info("Downloading {}. This may take a while...", (Object)name);
            logger.info("URL -> <{}>", (Object)url);
            if (!requiresRequest) {
                try (ReadableByteChannel in = Channels.newChannel(url.openStream());
                     FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    out.transferFrom(in, 0L, Long.MAX_VALUE);
                    break block49;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Sponge-Downloader");
            connection.connect();
            try (ReadableByteChannel in = Channels.newChannel(connection.getInputStream());
                 FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                out.transferFrom(in, 0L, Long.MAX_VALUE);
            }
        }
    }

    public static void downloadCheckHash(Logger logger, URL url, Path path, MessageDigest digest, String expected, boolean requiresRequest) throws IOException {
        String name;
        block74: {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            name = path.getFileName().toString();
            logger.info("Downloading {}. This may take a while...", (Object)name);
            logger.info("URL -> <{}>", (Object)url);
            if (!requiresRequest) {
                try (DigestInputStream stream = new DigestInputStream(url.openStream(), digest);
                     ReadableByteChannel in = Channels.newChannel(stream);
                     FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    out.transferFrom(in, 0L, Long.MAX_VALUE);
                    break block74;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Sponge-Downloader");
            connection.connect();
            try (DigestInputStream stream = new DigestInputStream(connection.getInputStream(), digest);
                 ReadableByteChannel in = Channels.newChannel(stream);
                 FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                out.transferFrom(in, 0L, Long.MAX_VALUE);
            }
        }
        String fileSha1 = InstallerUtils.toHexString(digest.digest());
        if (!expected.equalsIgnoreCase(fileSha1)) {
            Files.delete(path);
            throw new IOException(String.format("Checksum verification failed: Expected '%s', got '%s'.", expected, fileSha1));
        }
        logger.info("Successfully downloaded {} and verified checksum!", (Object)name);
    }
}

