/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch.plugin;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Optional;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.inject.plugin.PluginModule;
import org.spongepowered.plugin.InvalidPluginException;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.jvm.JVMPluginContainer;
import org.spongepowered.plugin.jvm.JVMPluginLoader;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaPluginLoader
extends JVMPluginLoader<JVMPluginContainer> {
    public Optional<JVMPluginContainer> createPluginContainer(PluginCandidate<JVMPluginResource> candidate, PluginEnvironment environment) {
        return Optional.of(new JVMPluginContainer(candidate));
    }

    protected Object createPluginInstance(PluginEnvironment environment, JVMPluginContainer container, ClassLoader targetClassLoader) throws InvalidPluginException {
        try {
            String mainClass = container.getMetadata().getMainClass();
            Class<?> pluginClass = Class.forName(mainClass, true, targetClassLoader);
            Injector parentInjector = environment.getBlackboard().get(SpongeBootstrap.PARENT_INJECTOR).orElse(null);
            if (parentInjector != null) {
                Injector childInjector = parentInjector.createChildInjector(new Module[]{new PluginModule((PluginContainer)container, pluginClass)});
                return childInjector.getInstance(pluginClass);
            }
            return pluginClass.newInstance();
        }
        catch (Exception ex) {
            throw new InvalidPluginException("An error occurred creating an instance of plugin '" + container.getMetadata().getId() + "'!", (Throwable)ex);
        }
    }
}

