/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.entity.player;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.dimension.DimensionTypeBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.RegisterDimensionTypePacket;
import org.spongepowered.common.network.packet.SpongePacketHandler;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin_Vanilla
implements ServerPlayerEntityBridge {
    @Shadow
    public abstract ServerWorld shadow$getServerWorld();

    @Override
    public void bridge$sendDimensionData(NetworkManager manager, DimensionType dimensionType) {
        if (this.bridge$getClientType() == ClientType.SPONGE_VANILLA) {
            SpongePacketHandler.getChannel().sendTo((ServerPlayer)((Object)this), (Packet)new RegisterDimensionTypePacket(dimensionType));
        }
    }

    @Override
    public void bridge$sendChangeDimension(DimensionType toDimensionType, long seed, WorldType generator, GameType gameType) {
        ServerPlayerEntity player = (ServerPlayerEntity)this;
        if (this.bridge$getClientType() == ClientType.SPONGE_VANILLA) {
            player.connection.sendPacket((IPacket)new SRespawnPacket(toDimensionType, seed, generator, gameType));
        } else {
            this.vanilla$hackChangeVanillaClientDimension(((DimensionTypeBridge)toDimensionType).bridge$getSpongeDimensionType(), seed, generator, gameType, true);
        }
    }

    @Override
    public void bridge$sendViewerEnvironment(SpongeDimensionType dimensionType) {
        if (this.bridge$getClientType() == ClientType.SPONGE_VANILLA) {
            SpongePacketHandler.getChannel().sendTo((ServerPlayer)((Object)this), (Packet)new ChangeViewerEnvironmentPacket(dimensionType));
        } else {
            WorldType generator = ((ServerPlayerEntity)this).getEntityWorld().getWorldInfo().getGenerator();
            GameType gameType = ((ServerPlayerEntity)this).interactionManager.getGameType();
            this.vanilla$hackChangeVanillaClientDimension(dimensionType, WorldInfo.byHashing((long)this.shadow$getServerWorld().getSeed()), generator, gameType, false);
        }
    }

    private void vanilla$hackChangeVanillaClientDimension(SpongeDimensionType logicType, long seed, WorldType generator, GameType gameType, boolean actualWorldChange) {
        ServerPlayerEntity player = (ServerPlayerEntity)this;
        SpongeDimensionType currentLogicType = ((DimensionTypeBridge)this.shadow$getServerWorld().dimension.getType()).bridge$getSpongeDimensionType();
        if (currentLogicType == logicType) {
            if (logicType == DimensionTypes.OVERWORLD.get()) {
                player.connection.sendPacket((IPacket)new SRespawnPacket(DimensionType.THE_NETHER, seed, generator, gameType));
            } else if (logicType == DimensionTypes.THE_NETHER.get()) {
                player.connection.sendPacket((IPacket)new SRespawnPacket(DimensionType.OVERWORLD, seed, generator, gameType));
            } else {
                player.connection.sendPacket((IPacket)new SRespawnPacket(DimensionType.THE_NETHER, seed, generator, gameType));
            }
        }
        if (logicType == DimensionTypes.OVERWORLD.get()) {
            player.connection.sendPacket((IPacket)new SRespawnPacket(DimensionType.OVERWORLD, seed, generator, gameType));
        } else if (logicType == DimensionTypes.THE_NETHER.get()) {
            player.connection.sendPacket((IPacket)new SRespawnPacket(DimensionType.THE_NETHER, seed, generator, gameType));
        } else {
            player.connection.sendPacket((IPacket)new SRespawnPacket(DimensionType.THE_END, seed, generator, gameType));
        }
        if (!actualWorldChange) {
            player.connection.setPlayerLocation(player.getPosX(), player.getPosY(), player.getPosZ(), player.rotationYaw, player.rotationPitch);
        }
    }
}

