/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.network.login;

import net.minecraft.network.login.IServerLoginNetHandler;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.network.channel.TransactionStore;

@Mixin(value={ServerLoginNetHandler.class})
public abstract class ServerLoginNetHandlerMixin_Vanilla
implements IServerLoginNetHandler {
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    private ServerLoginNetHandler.State currentLoginState;
    private static final int HANDSHAKE_NOT_STARTED = 0;
    private static final int HANDSHAKE_CLIENT_TYPE = 1;
    private static final int HANDSHAKE_SYNC_CHANNEL_REGISTRATIONS = 2;
    private static final int HANDSHAKE_SYNC_PLUGIN_DATA = 3;
    private int impl$handshakeState = 0;

    @Inject(method={"processCustomPayloadLogin"}, at={@At(value="HEAD")}, cancellable=true)
    private void onResponsePayload(CCustomPayloadLoginPacket packet, CallbackInfo ci) {
        ci.cancel();
        SpongeChannelRegistry channelRegistry = (SpongeChannelRegistry)Sponge.getChannelRegistry();
        this.server.execute(() -> channelRegistry.handleLoginResponsePayload((EngineConnection)((Object)this), packet));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void impl$onTick(CallbackInfo ci) {
        if (this.currentLoginState == ServerLoginNetHandler.State.NEGOTIATING) {
            TransactionStore store;
            ServerSideConnection connection = (ServerSideConnection)((Object)this);
            if (this.impl$handshakeState == 0) {
                this.impl$handshakeState = 1;
                ((SpongeChannelRegistry)Sponge.getChannelRegistry()).requestClientType(connection).thenAccept(result -> {
                    this.impl$handshakeState = 2;
                });
            } else if (this.impl$handshakeState == 2) {
                ((SpongeChannelRegistry)Sponge.getChannelRegistry()).sendLoginChannelRegistry(connection).thenAccept(result -> {
                    Cause cause = Cause.of(EventContext.empty(), this);
                    ServerSideConnectionEvent.Handshake event = SpongeEventFactory.createServerSideConnectionEventHandshake(cause, connection);
                    SpongeCommon.postEvent(event);
                    this.impl$handshakeState = 3;
                });
            } else if (this.impl$handshakeState == 3 && (store = ConnectionUtil.getTransactionStore(connection)).isEmpty()) {
                this.currentLoginState = ServerLoginNetHandler.State.READY_TO_ACCEPT;
            }
        }
    }

    @Inject(method={"tryAcceptPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;initializeConnectionToPlayer(Lnet/minecraft/network/NetworkManager;Lnet/minecraft/entity/player/ServerPlayerEntity;)V")})
    private void impl$onTryAcceptPlayer_beforeInitPlayer(CallbackInfo ci) {
        ServerSideConnection connection = (ServerSideConnection)((Object)this);
        ((SpongeChannelRegistry)Sponge.getChannelRegistry()).sendChannelRegistrations(connection);
    }

    @Inject(method={"processLoginStart"}, at={@At(value="RETURN")})
    private void impl$onProcessLoginStart(CLoginStartPacket packet, CallbackInfo ci) {
        if (this.currentLoginState == ServerLoginNetHandler.State.READY_TO_ACCEPT) {
            this.currentLoginState = ServerLoginNetHandler.State.NEGOTIATING;
        }
    }
}

