/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tinylog.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Agent {
    private static Instrumentation instrumentation;
    private static boolean usingFallback;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Agent.instrumentation = instrumentation;
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        Agent.instrumentation = instrumentation;
    }

    static void addJarToClasspath(Path jar) {
        if (instrumentation == null) {
            throw new IllegalStateException("The SpongeVanilla jar must be run as a java agent in order to add downloaded libraries to the classpath!");
        }
        try {
            Path normalized = Paths.get(jar.toRealPath(new LinkOption[0]).toUri().toURL().toURI());
            if (usingFallback) {
                Fallback.addToSystemClasspath(jar);
                return;
            }
            try (JarFile jf = new JarFile(new File(normalized.toUri()));){
                instrumentation.appendToSystemClassLoaderSearch(jf);
            }
            catch (IllegalArgumentException ex) {
                Logger.debug((Throwable)ex, "Failed to add library {} to classpath, transitioning to fallback (more unsafe!) method", jar);
                usingFallback = true;
                Fallback.addToSystemClasspath(jar);
            }
        }
        catch (IOException | URISyntaxException ex) {
            Logger.error((Throwable)ex, "Failed to create jar file for archive '{}'!", jar);
        }
    }

    static void crackModules() {
        Set<Module> systemUnnamed = Set.of(ClassLoader.getSystemClassLoader().getUnnamedModule());
        instrumentation.redefineModule(Manifest.class.getModule(), Set.of(), Map.of("sun.security.util", systemUnnamed), Map.of("java.util.jar", systemUnnamed), Set.of(), Map.of());
    }

    static final class Fallback {
        private static final Object SYSTEM_CLASS_PATH;
        private static final Method ADD_URL;

        Fallback() {
        }

        private static @Nullable Field fieldOrNull(@Nullable Class<?> clazz, String name) {
            if (clazz == null) {
                return null;
            }
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }

        static void addToSystemClasspath(Path file) {
            try {
                ADD_URL.invoke(SYSTEM_CLASS_PATH, file.toUri().toURL());
            }
            catch (IOException | IllegalAccessException | InvocationTargetException ex) {
                Logger.error((Throwable)ex, "Failed to add file {} to the system classpath", file);
                throw new RuntimeException(ex);
            }
        }

        static {
            Logger.debug("Initializing fallback classpath modification. This is only expected when using non-ASCII characters in file paths on Windows");
            Set<Module> systemUnnamed = Set.of(ClassLoader.getSystemClassLoader().getUnnamedModule());
            instrumentation.redefineModule(ClassLoader.class.getModule(), Set.of(), Map.of("jdk.internal.loader", systemUnnamed), Map.of("jdk.internal.loader", systemUnnamed), Set.of(), Map.of());
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Field ucp = Fallback.fieldOrNull(loader.getClass(), "ucp");
            if (ucp == null) {
                ucp = Fallback.fieldOrNull(loader.getClass().getSuperclass(), "ucp");
            }
            if (ucp == null) {
                throw new ExceptionInInitializerError("Unable to initialize fallback classpath handling on your system. Perhaps try a different Java version?");
            }
            try {
                SYSTEM_CLASS_PATH = ucp.get(loader);
                ADD_URL = SYSTEM_CLASS_PATH.getClass().getDeclaredMethod("addURL", URL.class);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

