/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.persistence;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DataQuery
implements Iterable<String> {
    private static final DataQuery EMPTY = new DataQuery(new String[0]);
    private final ImmutableList<String> parts;
    private @MonotonicNonNull ImmutableList<DataQuery> queryParts;

    private DataQuery(char separator, String path) {
        this(path.split(Pattern.quote(String.valueOf(separator))));
    }

    private DataQuery(String ... parts) {
        this.parts = ImmutableList.copyOf((Object[])parts);
    }

    private DataQuery(List<String> parts) {
        this.parts = ImmutableList.copyOf(parts);
    }

    public static DataQuery of() {
        return EMPTY;
    }

    public static DataQuery of(char separator, String path) {
        return new DataQuery(separator, path);
    }

    public static DataQuery of(String ... parts) {
        if (parts.length == 0) {
            return EMPTY;
        }
        return new DataQuery(parts);
    }

    public static DataQuery of(List<String> parts) {
        if (parts.isEmpty()) {
            return EMPTY;
        }
        return new DataQuery(parts);
    }

    public List<String> parts() {
        return this.parts;
    }

    public DataQuery then(DataQuery that) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.parts);
        builder.addAll(that.parts);
        return new DataQuery((List<String>)builder.build());
    }

    public DataQuery then(String that) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.parts);
        builder.add((Object)that);
        return new DataQuery((List<String>)builder.build());
    }

    public List<DataQuery> queryParts() {
        if (this.queryParts == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String part : this.parts()) {
                builder.add((Object)new DataQuery(part));
            }
            this.queryParts = builder.build();
        }
        return this.queryParts;
    }

    public DataQuery pop() {
        if (this.parts.size() <= 1) {
            return DataQuery.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.parts.size() - 1; ++i) {
            builder.add((Object)((String)this.parts.get(i)));
        }
        return new DataQuery((List<String>)builder.build());
    }

    public DataQuery popFirst() {
        if (this.parts.size() <= 1) {
            return DataQuery.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 1; i < this.parts.size(); ++i) {
            builder.add((Object)((String)this.parts.get(i)));
        }
        return new DataQuery((List<String>)builder.build());
    }

    public DataQuery last() {
        if (this.parts.size() <= 1) {
            return this;
        }
        return new DataQuery((String)this.parts.get(this.parts.size() - 1));
    }

    public String asString(String separator) {
        StringJoiner stringJoiner = new StringJoiner(separator);
        this.parts.forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    public String asString(char separator) {
        return this.asString(String.valueOf(separator));
    }

    public String toString() {
        return this.asString('.');
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataQuery other = (DataQuery)obj;
        return Objects.equals(this.parts, other.parts);
    }

    @Override
    public Iterator<String> iterator() {
        return this.parts.iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        this.parts.forEach(action);
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.parts.spliterator();
    }
}

