/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolderBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.math.vector.Vector3d;

public interface EntitySnapshot
extends LocatableSnapshot<EntitySnapshot> {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public Optional<UUID> uniqueId();

    public Optional<Transform> transform();

    public EntityType<?> type();

    public Optional<Entity> restore();

    public EntityArchetype createArchetype();

    public static interface Builder
    extends DataHolderBuilder.Immutable<EntitySnapshot, Builder>,
    DataBuilder<EntitySnapshot> {
        public Builder world(ServerWorldProperties var1);

        default public Builder type(Supplier<? extends EntityType<?>> entityType) {
            return this.type(entityType.get());
        }

        public Builder type(EntityType<?> var1);

        public Builder position(Vector3d var1);

        @Override
        public Builder from(Entity var1);
    }
}

