/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.map.color;

import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.map.color.MapColorType;
import org.spongepowered.api.map.color.MapShade;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.ResettableBuilder;

public interface MapColor
extends DataSerializable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static MapColor of(MapColorType mapColorType) {
        return MapColor.builder().baseColor(mapColorType).build();
    }

    public static MapColor of(Supplier<MapColorType> mapColorTypeSupplier) {
        return MapColor.of(mapColorTypeSupplier.get());
    }

    public static MapColor of(MapColorType mapColorType, MapShade mapShade) {
        return MapColor.builder().baseColor(mapColorType).shade(mapShade).build();
    }

    public static MapColor of(Supplier<MapColorType> mapColorTypeSupplier, Supplier<MapShade> mapShadeSupplier) {
        return MapColor.of(mapColorTypeSupplier.get(), mapShadeSupplier.get());
    }

    public MapColorType type();

    public MapShade shade();

    public Color color();

    public static interface Builder
    extends ResettableBuilder<MapColor, Builder> {
        public Builder shade(MapShade var1);

        public Builder base();

        public Builder dark();

        public Builder darker();

        public Builder darkest();

        public Builder baseColor(MapColorType var1);

        default public Builder baseColor(Supplier<MapColorType> mapColorTypeSupplier) {
            return this.baseColor(mapColorTypeSupplier.get());
        }

        public Builder from(MapColor var1);

        public Builder fromContainer(DataView var1);

        public MapColor build() throws IllegalStateException;
    }
}

