/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CopyFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path target;
    private final CopyOption[] options;
    private @Nullable Path source;

    public CopyFileVisitor(Path target, CopyOption ... options) {
        this.target = Objects.requireNonNull(target, "target");
        this.options = Objects.requireNonNull(options, "options");
    }

    private void copy(Path source, Path dest) throws IOException {
        Files.copy(source, dest, this.options);
    }

    private void copy(Path sourcePath) throws IOException {
        this.copy(sourcePath, this.target.resolve(this.source.relativize(sourcePath)));
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.target.equals(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (this.source == null) {
            this.source = dir;
            this.copy(dir, this.target);
        } else {
            this.copy(dir);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.copy(file);
        return FileVisitResult.CONTINUE;
    }
}

