/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.leangen.geantyref.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.SpongeCriterionTrigger;
import org.spongepowered.common.data.persistence.JsonDataFormat;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;

public final class SpongeTriggerBuilder<C extends FilteredTriggerConfiguration>
extends AbstractResourceKeyedBuilder<Trigger<C>, Trigger.Builder<C>>
implements Trigger.Builder<C> {
    private static final Gson GSON = new Gson();
    private static final FilteredTriggerConfiguration.Empty EMPTY_TRIGGER_CONFIGURATION = new FilteredTriggerConfiguration.Empty();
    private static final Function<JsonObject, FilteredTriggerConfiguration.Empty> EMPTY_TRIGGER_CONFIGURATION_CONSTRUCTOR = jsonObject -> EMPTY_TRIGGER_CONFIGURATION;
    private @Nullable Type configType;
    private @Nullable Function<JsonObject, C> constructor;
    private @Nullable Consumer<CriterionEvent.Trigger<C>> eventHandler;
    private @Nullable String name;

    @Override
    public <T extends FilteredTriggerConfiguration & DataSerializable> Trigger.Builder<T> dataSerializableConfig(Class<T> dataConfigClass) {
        Preconditions.checkNotNull(dataConfigClass, (Object)"dataConfigClass");
        this.configType = dataConfigClass;
        this.constructor = new DataSerializableConstructor(dataConfigClass);
        return this;
    }

    private static ConfigurationOptions defaultOptions() {
        return ConfigurationOptions.defaults().serializers(SpongeCommon.game().configManager().serializers());
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(TypeToken<T> configType) {
        return this.typeSerializableConfig(configType, SpongeTriggerBuilder.defaultOptions());
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(TypeToken<T> configType, ConfigurationOptions options) {
        Preconditions.checkNotNull(configType, (Object)"configType");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.configType = configType.getType();
        this.constructor = new ConfigurateConstructor(configType.getType(), options);
        return this;
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(TypeToken<T> configType, UnaryOperator<ConfigurationOptions> transformer) {
        return this.typeSerializableConfig(configType, (ConfigurationOptions)transformer.apply(SpongeTriggerBuilder.defaultOptions()));
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass) {
        return this.typeSerializableConfig(configClass, SpongeTriggerBuilder.defaultOptions());
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass, ConfigurationOptions options) {
        Preconditions.checkNotNull(configClass, (Object)"configClass");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.configType = configClass;
        this.constructor = new ConfigurateConstructor(configClass, options);
        return this;
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> typeSerializableConfig(Class<T> configClass, UnaryOperator<ConfigurationOptions> transformer) {
        Objects.requireNonNull(transformer, "transformer");
        return this.typeSerializableConfig(configClass, (ConfigurationOptions)transformer.apply(SpongeTriggerBuilder.defaultOptions()));
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> jsonSerializableConfig(Class<T> configClass, Gson gson) {
        Preconditions.checkNotNull(configClass, (Object)"configClass");
        this.configType = configClass;
        this.constructor = new JsonConstructor(configClass, gson);
        return this;
    }

    @Override
    public <T extends FilteredTriggerConfiguration> Trigger.Builder<T> jsonSerializableConfig(Class<T> configClass) {
        return this.jsonSerializableConfig(configClass, GSON);
    }

    @Override
    public Trigger.Builder<FilteredTriggerConfiguration.Empty> emptyConfig() {
        this.configType = FilteredTriggerConfiguration.Empty.class;
        this.constructor = EMPTY_TRIGGER_CONFIGURATION_CONSTRUCTOR;
        return this;
    }

    @Override
    public Trigger.Builder<C> listener(Consumer<CriterionEvent.Trigger<C>> eventListener) {
        this.eventHandler = eventListener;
        return this;
    }

    @Override
    public Trigger.Builder<C> name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.name = name;
        return this;
    }

    @Override
    public Trigger<C> build0() {
        Objects.requireNonNull(this.name, "name");
        Preconditions.checkState((!this.name.isEmpty() ? 1 : 0) != 0, (Object)"The name cannot be empty!");
        Preconditions.checkState((this.configType != null ? 1 : 0) != 0, (Object)"The configType must be set");
        return (Trigger)((Object)new SpongeCriterionTrigger(this.configType, this.constructor, (ResourceLocation)this.key, this.eventHandler, this.name));
    }

    @Override
    public Trigger.Builder<C> from(Trigger<C> value) {
        this.configType = value.configurationType();
        if (value instanceof SpongeCriterionTrigger) {
            this.constructor = ((SpongeCriterionTrigger)((Object)value)).constructor;
            this.eventHandler = ((SpongeCriterionTrigger)((Object)value)).getEventHandler();
            this.name = ((SpongeCriterionTrigger)((Object)value)).getName();
        }
        return this;
    }

    @Override
    public Trigger.Builder<C> reset() {
        this.key = null;
        this.configType = null;
        this.constructor = null;
        this.eventHandler = null;
        this.name = null;
        return this;
    }

    private static class ConfigurateConstructor<C extends FilteredTriggerConfiguration>
    implements Function<JsonObject, C> {
        private final Type typeToken;
        private final ConfigurationOptions options;

        private ConfigurateConstructor(Type typeToken, ConfigurationOptions options) {
            this.typeToken = typeToken;
            this.options = options;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().defaultOptions(this.options)).source(() -> new BufferedReader(new StringReader(GSON.toJson(jsonObject))))).build();
            try {
                ConfigurationNode node = loader.load();
                return (C)((FilteredTriggerConfiguration)node.get(this.typeToken));
            }
            catch (ConfigurateException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class DataSerializableConstructor<C extends FilteredTriggerConfiguration & DataSerializable>
    implements Function<JsonObject, C> {
        private final Class<C> dataConfigClass;

        private DataSerializableConstructor(Class<C> dataConfigClass) {
            this.dataConfigClass = dataConfigClass;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            DataBuilder<C> builder = Sponge.dataManager().builder(this.dataConfigClass).get();
            try {
                DataContainer dataView = JsonDataFormat.serialize(GSON, jsonObject);
                return (C)((FilteredTriggerConfiguration)builder.build(dataView).get());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class JsonConstructor<C extends FilteredTriggerConfiguration>
    implements Function<JsonObject, C> {
        private final Type configClass;
        private final Gson gson;

        private JsonConstructor(Type configClass, Gson gson) {
            this.configClass = configClass;
            this.gson = gson;
        }

        @Override
        public C apply(JsonObject jsonObject) {
            return (C)((FilteredTriggerConfiguration)this.gson.fromJson((JsonElement)jsonObject, this.configClass));
        }
    }
}

