/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.tree;

import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;

public final class UnsortedNodeHolder {
    private final List<CommandNode<CommandSourceStack>> standardChildren = new LinkedList<CommandNode<CommandSourceStack>>();
    private final List<CommandNode<CommandSourceStack>> redirectingChildren = new LinkedList<CommandNode<CommandSourceStack>>();
    private @Nullable List<CommandNode<CommandSourceStack>> cachedResult;

    public void add(CommandNode<CommandSourceStack> node) {
        this.cachedResult = null;
        if (node.getRedirect() == null) {
            this.standardChildren.add(node);
        } else {
            this.redirectingChildren.add(node);
        }
    }

    public Collection<CommandNode<CommandSourceStack>> getChildren() {
        if (this.cachedResult == null) {
            LinkedList<CommandNode<CommandSourceStack>> result = new LinkedList<CommandNode<CommandSourceStack>>();
            result.addAll(this.standardChildren);
            result.addAll(this.redirectingChildren);
            this.cachedResult = Collections.unmodifiableList(result);
        }
        return this.cachedResult;
    }

    public Collection<CommandNode<CommandSourceStack>> getChildrenForSuggestions() {
        ArrayList<CommandNode<CommandSourceStack>> nodes = new ArrayList<CommandNode<CommandSourceStack>>();
        for (CommandNode<CommandSourceStack> childNode : this.getChildren()) {
            if (childNode instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)childNode).getParser().doesNotRead()) {
                CommandNode redirected = childNode.getRedirect();
                if (redirected != null) {
                    if (redirected instanceof SpongeArgumentCommandNode) {
                        nodes.addAll(((SpongeArgumentCommandNode)redirected).getChildrenForSuggestions());
                        continue;
                    }
                    nodes.addAll(redirected.getChildren());
                    continue;
                }
                nodes.addAll(((SpongeArgumentCommandNode)childNode).getChildrenForSuggestions());
                continue;
            }
            nodes.add(childNode);
        }
        nodes.sort((first, second) -> {
            if (first.getRedirect() == null) {
                return second.getRedirect() == null ? 0 : -1;
            }
            if (second.getRedirect() == null) {
                return 1;
            }
            if (first.getRedirect() == second) {
                return 1;
            }
            if (second.getRedirect() == first) {
                return -1;
            }
            return 0;
        });
        return nodes;
    }
}

