/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.api.config.ConfigRoot;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.config.PluginConfigManager;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public final class PluginConfigRoot
implements ConfigRoot {
    private final TypeSerializerCollection serializers;
    private final String pluginName;
    private final Path baseDir;

    PluginConfigRoot(TypeSerializerCollection serializers, String pluginName, Path baseDir) {
        this.serializers = serializers;
        this.pluginName = pluginName;
        this.baseDir = baseDir;
    }

    @Override
    public Path configPath() {
        Path configFile = this.baseDir.resolve(this.pluginName + ".conf");
        try {
            Files.createDirectories(this.baseDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Failed to create plugin dir for {} at {}", (Object)this.pluginName, (Object)this.baseDir, (Object)e);
        }
        return configFile;
    }

    @Override
    public ConfigurationLoader<CommentedConfigurationNode> config() {
        return this.config(PluginConfigManager.getOptions(this.serializers));
    }

    @Override
    public ConfigurationLoader<CommentedConfigurationNode> config(ConfigurationOptions options) {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(this.configPath())).defaultOptions(options)).build();
    }

    @Override
    public Path directory() {
        return this.baseDir;
    }
}

