/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.tracker;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class NamespacedCategory {
    @Setting
    @Comment(value="If 'false', all tracking for this mod will be disabled.")
    public boolean enabled = true;
    @Setting
    public Map<String, ValueCategory> types = new HashMap<String, ValueCategory>();

    public boolean enabled() {
        return this.enabled;
    }

    public ValueCategory valueOrCreate(String value) {
        return this.types.computeIfAbsent(value, k -> new ValueCategory());
    }

    @ConfigSerializable
    public static final class ValueCategory {
        @Setting(value="block-bulk-capture")
        public boolean blockBulkCapture = true;
        @Setting(value="entity-bulk-capture")
        public boolean entityBulkCapture = true;
        @Setting(value="block-event-creation")
        public boolean blockEventCreation = true;
        @Setting(value="entity-block-creation")
        public boolean entityEventCreation = true;

        public boolean allowsBlockEvents() {
            return this.blockEventCreation;
        }

        public void setAllowBlockEvents(boolean allowBlockEvents) {
            this.blockEventCreation = allowBlockEvents;
        }

        public boolean allowsEntityEvents() {
            return this.entityEventCreation;
        }

        public void setAllowEntityEvents(boolean allowEntityEvents) {
            this.entityEventCreation = allowEntityEvents;
        }

        public boolean capturesBlocksInBulk() {
            return this.blockBulkCapture;
        }

        public void setCaptureBlocksInBulk(boolean captureBlocksInBulk) {
            this.blockBulkCapture = captureBlocksInBulk;
        }

        public boolean capturesEntitiesInBulk() {
            return this.entityBulkCapture;
        }

        public void setCaptureEntitiesInBulk(boolean captureEntitiesInBulk) {
            this.entityBulkCapture = captureEntitiesInBulk;
        }
    }
}

