/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.value.Value;

public final class ByteToBooleanContentUpdater
implements DataContentUpdater {
    private final int from;
    private final int to;
    private final List<DataQuery> queries;

    @SafeVarargs
    public ByteToBooleanContentUpdater(int from, int to, Key<Value<Boolean>> ... booleanKeys) {
        this.from = from;
        this.to = to;
        this.queries = Arrays.stream(booleanKeys).map(k -> DataQuery.of(k.key().value())).collect(Collectors.toList());
    }

    @Override
    public int inputVersion() {
        return this.from;
    }

    @Override
    public int outputVersion() {
        return this.to;
    }

    @Override
    public DataView update(DataView content) {
        for (DataQuery query : this.queries) {
            byte aByte = content.getByte(query).orElse((byte)1);
            content.remove(query);
            content.set(query, aByte == 1);
        }
        return content;
    }
}

