/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DuplicateDataStoreException;
import org.spongepowered.api.data.DuplicateProviderException;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.common.data.SpongeDataRegistration;

public final class SpongeDataRegistrationBuilder
implements DataRegistration.Builder {
    Multimap<Key, DataProvider> dataProviderMap = HashMultimap.create();
    Map<Type, DataStore> dataStoreMap = new HashMap<Type, DataStore>();
    List<Key<?>> keys = new ArrayList();

    @Override
    public DataRegistration.Builder store(DataStore store) throws DuplicateDataStoreException {
        for (Type holderType : store.supportedTypes()) {
            this.dataStoreMap.put(holderType, store);
        }
        return this;
    }

    @Override
    public DataRegistration.Builder provider(DataProvider<?, ?> provider) throws DuplicateProviderException {
        this.dataProviderMap.put(provider.key(), provider);
        return this;
    }

    @Override
    public DataRegistration.Builder dataKey(Key<?> key) {
        this.keys.add(key);
        return this;
    }

    @Override
    public DataRegistration.Builder dataKey(Key<?> key, Key<?> ... others) {
        this.keys.add(key);
        Collections.addAll(this.keys, others);
        return this;
    }

    @Override
    public DataRegistration.Builder dataKey(Iterable<Key<?>> keys) {
        keys.forEach(this.keys::add);
        return this;
    }

    @Override
    public DataRegistration build() {
        return new SpongeDataRegistration(this);
    }

    @Override
    public SpongeDataRegistrationBuilder reset() {
        this.dataProviderMap = HashMultimap.create();
        this.dataStoreMap = new IdentityHashMap<Type, DataStore>();
        this.keys = new ArrayList();
        return this;
    }
}

