/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.effect.particle.CachedParticlePacket;
import org.spongepowered.common.effect.particle.NumericalParticleType;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3f;

public final class SpongeParticleHelper {
    public static void sendPackets(ParticleEffect particleEffect, Vector3d position, int radius, ResourceKey<Level> type, PlayerList playerList) {
        List<Packet<?>> packets = SpongeParticleHelper.toPackets(particleEffect, position);
        if (!packets.isEmpty()) {
            double x = position.x();
            double y = position.y();
            double z = position.z();
            for (Packet<?> packet : packets) {
                playerList.broadcast(null, x, y, z, (double)radius, type, packet);
            }
        }
    }

    public static List<Packet<?>> toPackets(ParticleEffect effect, Vector3d position) {
        SpongeParticleEffect spongeEffect = (SpongeParticleEffect)effect;
        CachedParticlePacket cachedPacket = spongeEffect.cachedPacket;
        if (cachedPacket == null) {
            cachedPacket = spongeEffect.cachedPacket = SpongeParticleHelper.getCachedPacket(spongeEffect);
        }
        ArrayList packets = new ArrayList();
        cachedPacket.process(position, packets);
        return packets;
    }

    public static CachedParticlePacket getCachedPacket(SpongeParticleEffect effect) {
        org.spongepowered.api.effect.particle.ParticleType type = effect.type();
        if (type instanceof NumericalParticleType) {
            return SpongeParticleHelper.getNumericalPacket(effect, (NumericalParticleType)type);
        }
        return SpongeParticleHelper.getNamedPacket(effect, (ParticleType)type);
    }

    private static CachedParticlePacket getNumericalPacket(ParticleEffect effect, NumericalParticleType type) {
        int effectId = type.getId();
        return new NumericalCachedPacket(effectId, type.getData(effect), false);
    }

    private static CachedParticlePacket getNamedPacket(ParticleEffect effect, ParticleType<?> internalType) {
        Vector3f offset = effect.optionOrDefault(ParticleOptions.OFFSET).get().toFloat();
        int quantity = effect.optionOrDefault(ParticleOptions.QUANTITY).get();
        Vector3f velocity = effect.optionOrDefault(ParticleOptions.VELOCITY).orElse(Vector3d.ZERO).toFloat();
        if (internalType instanceof SimpleParticleType) {
            return new NamedCachedPacket((net.minecraft.core.particles.ParticleOptions)internalType, offset, quantity, velocity);
        }
        if (internalType.getDeserializer() == BlockParticleOption.DESERIALIZER) {
            BlockState state = effect.optionOrDefault(ParticleOptions.BLOCK_STATE).get();
            BlockParticleOption particleData = new BlockParticleOption(internalType, (net.minecraft.world.level.block.state.BlockState)state);
            return new NamedCachedPacket((net.minecraft.core.particles.ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType.getDeserializer() == ItemParticleOption.DESERIALIZER) {
            ItemStackSnapshot snapshot = effect.optionOrDefault(ParticleOptions.ITEM_STACK_SNAPSHOT).get();
            ItemParticleOption particleData = new ItemParticleOption(internalType, (ItemStack)snapshot.createStack());
            return new NamedCachedPacket((net.minecraft.core.particles.ParticleOptions)particleData, offset, quantity, velocity);
        }
        if (internalType.getDeserializer() == DustParticleOptions.DESERIALIZER) {
            Color color = effect.optionOrDefault(ParticleOptions.COLOR).get();
            double scale = effect.optionOrDefault(ParticleOptions.SCALE).get();
            DustParticleOptions particleData = new DustParticleOptions((float)color.red() / 255.0f, (float)color.green() / 255.0f, (float)color.blue() / 255.0f, (float)scale);
            return new NamedCachedPacket((net.minecraft.core.particles.ParticleOptions)particleData, offset, quantity, velocity);
        }
        return EmptyCachedPacket.INSTANCE;
    }

    public static int getDirectionId(Direction direction) {
        if (direction.isSecondaryOrdinal()) {
            direction = Direction.closest(direction.asOffset(), Direction.Division.ORDINAL);
        }
        switch (direction) {
            case SOUTHEAST: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case SOUTHWEST: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 5;
            }
            case NORTHEAST: {
                return 6;
            }
            case NORTH: {
                return 7;
            }
            case NORTHWEST: {
                return 8;
            }
        }
        return 4;
    }

    public static int getBlockStateId(ParticleEffect effect, Optional<BlockState> defaultBlockState) {
        Optional<BlockState> blockState = effect.option(ParticleOptions.BLOCK_STATE);
        if (blockState.isPresent()) {
            return Block.getId((net.minecraft.world.level.block.state.BlockState)((net.minecraft.world.level.block.state.BlockState)blockState.get()));
        }
        Optional<ItemStackSnapshot> itemSnapshot = effect.option(ParticleOptions.ITEM_STACK_SNAPSHOT);
        if (itemSnapshot.isPresent()) {
            Optional<BlockType> blockType = itemSnapshot.get().type().block();
            return blockType.map(type -> Block.getId((net.minecraft.world.level.block.state.BlockState)((net.minecraft.world.level.block.state.BlockState)type.defaultState()))).orElse(0);
        }
        return defaultBlockState.map(state -> Block.getId((net.minecraft.world.level.block.state.BlockState)((net.minecraft.world.level.block.state.BlockState)state))).orElse(0);
    }

    private static final class NumericalCachedPacket
    implements CachedParticlePacket {
        private final int type;
        private final int data;
        private final boolean broadcast;

        public NumericalCachedPacket(int type, int data, boolean broadcast) {
            this.type = type;
            this.data = data;
            this.broadcast = broadcast;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            BlockPos blockPos = new BlockPos(position.floorX(), position.floorY(), position.floorZ());
            ClientboundLevelEventPacket packet = new ClientboundLevelEventPacket(this.type, blockPos, this.data, this.broadcast);
            output.add((Packet<?>)packet);
        }
    }

    private static final class NamedCachedPacket
    implements CachedParticlePacket {
        private final net.minecraft.core.particles.ParticleOptions particleData;
        private final Vector3f offset;
        private final int quantity;
        private final Vector3f velocity;

        public NamedCachedPacket(net.minecraft.core.particles.ParticleOptions particleData, Vector3f offset, int quantity, Vector3f velocity) {
            this.particleData = particleData;
            this.offset = offset;
            this.quantity = quantity;
            this.velocity = velocity;
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
            float posX = (float)position.x();
            float posY = (float)position.y();
            float posZ = (float)position.z();
            float offX = this.offset.x();
            float offY = this.offset.y();
            float offZ = this.offset.z();
            if (this.velocity.equals((Object)Vector3f.ZERO)) {
                ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(this.particleData, true, (double)posX, (double)posY, (double)posZ, offX, offY, offZ, 0.0f, this.quantity);
                output.add((Packet<?>)packet);
            } else {
                float velocityX = this.velocity.x();
                float velocityY = this.velocity.y();
                float velocityZ = this.velocity.z();
                Random random = new Random();
                for (int i = 0; i < this.quantity; ++i) {
                    float px0 = posX + (random.nextFloat() * 2.0f - 1.0f) * offX;
                    float py0 = posY + (random.nextFloat() * 2.0f - 1.0f) * offY;
                    float pz0 = posZ + (random.nextFloat() * 2.0f - 1.0f) * offZ;
                    ClientboundLevelParticlesPacket message = new ClientboundLevelParticlesPacket(this.particleData, true, (double)px0, (double)py0, (double)pz0, velocityX, velocityY, velocityZ, 1.0f, 0);
                    output.add((Packet<?>)message);
                }
            }
        }
    }

    private static final class EmptyCachedPacket
    implements CachedParticlePacket {
        public static final EmptyCachedPacket INSTANCE = new EmptyCachedPacket();

        private EmptyCachedPacket() {
        }

        @Override
        public void process(Vector3d position, List<Packet<?>> output) {
        }
    }
}

