/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, Entity>
implements EntityArchetype,
DataContainerHolder.Mutable {
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeEntityArchetype.class);
    private @Nullable Vector3d position;

    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        this(builder.entityType, builder.compound);
        this.position = builder.position;
    }

    private SpongeEntityArchetype(EntityType<@NonNull ?> type, @Nullable CompoundTag compound) {
        super(type, compound != null ? compound : new CompoundTag());
    }

    @Override
    public EntityType<@NonNull ?> type() {
        return (EntityType)this.type;
    }

    public @Nullable CompoundTag getData() {
        return this.compound;
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    public Optional<Vector3d> getPosition() {
        if (this.position != null) {
            return Optional.of(this.position);
        }
        if (!this.compound.contains("Pos", 9)) {
            return Optional.empty();
        }
        try {
            ListTag pos = this.compound.getList("Pos", 6);
            double x = pos.getDouble(0);
            double y = pos.getDouble(1);
            double z = pos.getDouble(2);
            this.position = new Vector3d(x, y, z);
            return Optional.of(this.position);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public DataContainer data$getDataContainer() {
        return this.entityData();
    }

    @Override
    public void data$setDataContainer(DataContainer container) {
        this.compound = NBTTranslator.INSTANCE.translate(Objects.requireNonNull(container, "DataContainer cannot be null!"));
    }

    @Override
    public DataContainer entityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.compound);
    }

    @Override
    public Optional<Entity> apply(ServerLocation location) {
        boolean requiresInitialSpawn;
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return Optional.empty();
        }
        ServerWorld spongeWorld = (ServerWorld)location.world();
        ServerLevel level = (ServerLevel)spongeWorld;
        ResourceLocation key = net.minecraft.world.entity.EntityType.getKey((net.minecraft.world.entity.EntityType)((net.minecraft.world.entity.EntityType)this.type));
        if (key == null) {
            return Optional.empty();
        }
        CompoundTag compound = this.compound.copy();
        compound.putString("id", key.toString());
        ListTag pos = new ListTag();
        pos.add((Object)DoubleTag.valueOf((double)location.x()));
        pos.add((Object)DoubleTag.valueOf((double)location.y()));
        pos.add((Object)DoubleTag.valueOf((double)location.z()));
        compound.put("Pos", (Tag)pos);
        compound.remove("UUID");
        if (compound.contains("RequireInitialSpawn")) {
            requiresInitialSpawn = compound.getBoolean("RequireInitialSpawn");
            compound.remove("RequireInitialSpawn");
        } else {
            requiresInitialSpawn = true;
        }
        @Nullable net.minecraft.world.entity.Entity entity = net.minecraft.world.entity.EntityType.loadEntityRecursive((CompoundTag)compound, (Level)level, e -> {
            e.moveTo(location.x(), location.y(), location.z());
            if (requiresInitialSpawn && e instanceof Mob) {
                ((Mob)e).finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(e.blockPosition()), MobSpawnType.COMMAND, null, compound);
            }
            return e;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (level.tryAddFreshEntityWithPassengers(entity)) {
            return Optional.of((Entity)entity);
        }
        return Optional.empty();
    }

    @Override
    public EntitySnapshot toSnapshot(ServerLocation location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        CompoundTag newCompound = this.compound.copy();
        Vector3d pos = location.position();
        newCompound.put("Pos", (Tag)Constants.NBT.newDoubleNBTList(pos.x(), pos.y(), pos.z()));
        newCompound.putString("WorldKey", location.worldKey().formatted());
        builder.compound = newCompound;
        builder.worldKey = ((ServerWorld)location.world()).properties().key();
        builder.position = pos;
        builder.rotation = this.getRotation();
        builder.scale = Vector3d.ONE;
        return builder.build();
    }

    private Vector3d getRotation() {
        ListTag tag = this.compound.getList("Rotation", 5);
        float rotationYaw = tag.getFloat(0);
        float rotationPitch = tag.getFloat(1);
        return new Vector3d(rotationPitch, rotationYaw, 0.0f);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.Sponge.EntityArchetype.ENTITY_TYPE, this.type).set(Constants.Sponge.EntityArchetype.ENTITY_DATA, this.entityData());
    }

    @Override
    protected ValidationType getValidationType() {
        return ValidationTypes.ENTITY.get();
    }

    @Override
    public SpongeEntityArchetype copy() {
        return new SpongeEntityArchetype((EntityType)this.type, this.compound.copy());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeEntityArchetype that = (SpongeEntityArchetype)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("position", (Object)this.position).add("type", this.type).toString();
    }
}

