/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.common.accessor.world.level.block.DispenserBlockAccessor;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;

public final class DispenserSourceLogic
implements ProjectileSourceLogic<Dispenser> {
    DispenserSourceLogic() {
    }

    @Override
    public <P extends Projectile> Optional<P> launch(ProjectileLogic<P> logic, Dispenser source, EntityType<P> projectileType, Object ... args) {
        if (args.length == 1 && args[0] instanceof Item) {
            return this.launch((DispenserBlockEntity)source, projectileType, (Item)args[0]);
        }
        Optional<P> projectile = logic.createProjectile(source, projectileType, source.location());
        if (projectile.isPresent()) {
            Direction enumfacing = DispenserSourceLogic.getFacing((DispenserBlockEntity)source);
            Entity projectileEntity = (Entity)projectile.get();
            BlockPos adjustedPosition = projectileEntity.blockPosition().offset(enumfacing.getNormal());
            projectileEntity.setPos((double)adjustedPosition.getX(), (double)adjustedPosition.getY(), (double)adjustedPosition.getZ());
        }
        return projectile;
    }

    public static Direction getFacing(DispenserBlockEntity dispenser) {
        BlockState state = dispenser.getLevel().getBlockState(dispenser.getBlockPos());
        return (Direction)state.getValue((Property)DispenserBlock.FACING);
    }

    private <P extends Projectile> Optional<P> launch(DispenserBlockEntity dispenser, EntityType<P> projectileType, Item item) {
        DispenseItemBehavior behavior = DispenserBlockAccessor.accessor$DISPENSER_REGISTRY().get(item);
        ServerLevel world = (ServerLevel)dispenser.getLevel();
        behavior.dispense((BlockSource)new BlockSourceImpl(world, dispenser.getBlockPos()), new ItemStack((ItemLike)item));
        List entities = world.getEntities((net.minecraft.world.entity.EntityType)projectileType, entity -> true);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Projectile)entities.get(entities.size() - 1));
    }
}

