/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.world.entity.item.FallingBlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.accessor.world.damagesource.DamageSourceAccessor;
import org.spongepowered.common.accessor.world.entity.item.FallingBlockEntityAccessor;
import org.spongepowered.common.util.MinecraftFallingBlockDamageSource;

public final class SpongeFallingBlockDamgeSourceBuilder
extends AbstractDamageSourceBuilder<FallingBlockDamageSource, FallingBlockDamageSource.Builder>
implements FallingBlockDamageSource.Builder {
    protected WeakReference<Entity> reference = null;

    @Override
    public SpongeFallingBlockDamgeSourceBuilder entity(Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof FallingBlock));
        this.reference = new WeakReference<Entity>(entity);
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder fire() {
        return null;
    }

    @Override
    public FallingBlockDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.reference.get() != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        MinecraftFallingBlockDamageSource damageSource = new MinecraftFallingBlockDamageSource(this.damageType.name(), (FallingBlockEntity)this.reference.get());
        DamageSourceAccessor accessor = (DamageSourceAccessor)((Object)damageSource);
        if (this.creative) {
            accessor.invoker$bypassInvul();
        }
        if (this.scales) {
            damageSource.setScalesWithDifficulty();
        }
        if (this.magical) {
            damageSource.setMagic();
        }
        if (this.bypasses) {
            accessor.invoker$bypassArmor();
        }
        if (this.absolute) {
            accessor.invoker$bypassMagic();
        }
        if (this.explosion) {
            damageSource.setExplosion();
        }
        if (this.exhaustion != null) {
            accessor.accessor$exhaustion(this.exhaustion.floatValue());
        }
        return (FallingBlockDamageSource)((Object)damageSource);
    }

    @Override
    public FallingBlockDamageSource.Builder from(FallingBlockDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<FallingBlock>(value.source());
        return this;
    }

    @Override
    public SpongeFallingBlockDamgeSourceBuilder reset() {
        super.reset();
        this.reference = null;
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder places(boolean canPlace) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public FallingBlockDamageSource.Builder fallTime(Ticks time) {
        if (this.reference == null) {
            throw new IllegalArgumentException("Cannot set fall time without an entity");
        }
        if (time.ticks() < 0L) {
            throw new IllegalArgumentException("Cannot set fall time to a negative value");
        }
        Entity entity = (Entity)this.reference.get();
        if (entity instanceof FallingBlockEntityAccessor) {
            ((FallingBlockEntityAccessor)((Object)entity)).accessor$time((int)time.ticks());
        }
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder hurtsEntities(boolean hurts) {
        if (this.reference == null) {
            throw new IllegalArgumentException("Cannot set hurt entities without an entity");
        }
        Entity entity = (Entity)this.reference.get();
        if (entity instanceof FallingBlockEntityAccessor) {
            ((FallingBlockEntityAccessor)((Object)entity)).accessor$hurtEntities(hurts);
        }
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder maxDamage(double damage) {
        if (this.reference == null) {
            throw new IllegalArgumentException("Cannot set max damage without an entity");
        }
        Entity entity = (Entity)this.reference.get();
        if (entity instanceof FallingBlockEntityAccessor) {
            ((FallingBlockEntityAccessor)((Object)entity)).accessor$fallDamageMax((int)damage);
        }
        return this;
    }

    @Override
    public FallingBlockDamageSource.Builder damagePerBlock(double damagePer) {
        if (this.reference == null) {
            throw new IllegalArgumentException("Cannot set max damage without an entity");
        }
        Entity entity = (Entity)this.reference.get();
        if (entity instanceof FallingBlockEntityAccessor) {
            ((FallingBlockEntityAccessor)((Object)entity)).accessor$fallDamageAmount((float)damagePer);
        }
        return this;
    }
}

