/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.EnchantItemEvent;
import org.spongepowered.api.event.item.inventory.TransferInventoryEvent;
import org.spongepowered.api.event.item.inventory.UpdateAnvilEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.AnvilCost;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.inventory.UpdateAnvilEventCost;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.enchantment.SpongeRandomEnchantmentListBuilder;
import org.spongepowered.common.item.util.ItemStackUtil;

public class InventoryEventFactory {
    public static boolean callPlayerChangeInventoryPickupPreEvent(Player player, ItemEntity itemToPickup) {
        ItemStack stack = itemToPickup.getItem();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(PhaseTracker.getCauseStackManager().currentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)player.inventory, (Item)itemToPickup, snapshot);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return false;
        }
        if (event.custom().isPresent()) {
            List<ItemStackSnapshot> list = event.custom().get();
            if (list.isEmpty()) {
                itemToPickup.getItem().setCount(0);
                return false;
            }
            PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
            TransactionalCaptureSupplier transactor = context.getTransactor();
            try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.PICKUP);){
                for (ItemStackSnapshot item : list) {
                    org.spongepowered.api.item.inventory.ItemStack itemStack = item.createStack();
                    player.inventory.add(ItemStackUtil.toNative(itemStack));
                    if (itemStack.isEmpty()) continue;
                    ignored.parent.markCancelled();
                    boolean bl = false;
                    return bl;
                }
            }
            if (!TrackingUtil.processBlockCaptures(context)) {
                return false;
            }
            itemToPickup.getItem().setCount(0);
        }
        return true;
    }

    public static ItemStack callInventoryPickupEvent(net.minecraft.world.Container inventory, ItemEntity item, ItemStack stack) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(inventory);
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(frame.currentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)inventory, (Item)item, snapshot);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                ItemStack itemStack = stack;
                return itemStack;
            }
            int size = inventory.getContainerSize();
            ItemStack[] prevInventory = new ItemStack[size];
            for (int i = 0; i < size; ++i) {
                prevInventory[i] = inventory.getItem(i);
            }
            if (event.custom().isPresent()) {
                ItemStack itemStack;
                if (event.custom().get().isEmpty()) {
                    ItemStack i = ItemStack.EMPTY;
                    return i;
                }
                boolean fullTransfer = true;
                for (ItemStackSnapshot snap : event.custom().get()) {
                    ItemStack stackToAdd = ItemStackUtil.fromSnapshotToNative(snap);
                    ItemStack remaining = HopperBlockEntity.addItem(null, (net.minecraft.world.Container)inventory, (ItemStack)stackToAdd, null);
                    if (remaining.isEmpty()) continue;
                    fullTransfer = false;
                    break;
                }
                if (!fullTransfer) {
                    for (int i = 0; i < prevInventory.length; ++i) {
                        inventory.setItem(i, prevInventory[i]);
                    }
                    ItemStack itemStack2 = stack;
                    return itemStack2;
                }
                if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                    itemStack = ItemStack.EMPTY;
                    return itemStack;
                }
                itemStack = stack;
                return itemStack;
            }
            ItemStack remainder = HopperBlockEntity.addItem(null, (net.minecraft.world.Container)inventory, (ItemStack)stack, null);
            if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                ItemStack itemStack = remainder;
                return itemStack;
            }
            ItemStack itemStack = stack;
            return itemStack;
        }
    }

    private static boolean callInventoryPickupEvent(net.minecraft.world.Container inventory, ItemStack[] prevInventory) {
        Inventory spongeInventory = InventoryUtil.toInventory(inventory, null);
        List<SlotTransaction> trans = InventoryEventFactory.generateTransactions(spongeInventory, inventory, prevInventory);
        if (trans.isEmpty()) {
            return true;
        }
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(PhaseTracker.getCauseStackManager().currentCause(), spongeInventory, trans);
        SpongeCommon.post(event);
        PacketPhaseUtil.handleSlotRestore(null, null, event.transactions(), event.isCancelled());
        return !event.isCancelled();
    }

    private static List<SlotTransaction> generateTransactions(@Nullable Inventory inv, net.minecraft.world.Container inventory, ItemStack[] previous) {
        if (inv == null) {
            return Collections.emptyList();
        }
        ArrayList<SlotTransaction> trans = new ArrayList<SlotTransaction>();
        List<Slot> slots = inv.slots();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack prevStack;
            Slot slot = slots.get(i);
            ItemStack newStack = inventory.getItem(i);
            if (ItemStack.matches((ItemStack)newStack, (ItemStack)(prevStack = previous[i]))) continue;
            trans.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(prevStack), ItemStackUtil.snapshotOf(newStack)));
        }
        return trans;
    }

    public static boolean callInteractContainerOpenEvent(ServerPlayer player) {
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.inventory.getCarried());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), newCursor);
        InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen(PhaseTracker.getCauseStackManager().currentCause(), (Container)player.containerMenu, cursorTransaction);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            player.closeContainer();
            return false;
        }
        PacketPhaseUtil.handleCursorRestore((Player)player, event.cursorTransaction());
        return true;
    }

    public static @Nullable AbstractContainerMenu displayContainer(ServerPlayer player, Inventory inventory, Component displayName) {
        AbstractContainerMenu container;
        AbstractContainerMenu previousContainer = player.containerMenu;
        Optional<ViewableInventory> viewable = inventory.asViewable();
        if (viewable.isPresent()) {
            if (viewable.get() instanceof MenuProvider) {
                MenuProvider namedContainerProvider = (MenuProvider)viewable.get();
                if (displayName != null) {
                    namedContainerProvider = new SimpleMenuProvider((MenuConstructor)namedContainerProvider, SpongeAdventure.asVanilla(displayName));
                }
                player.openMenu(namedContainerProvider);
            } else if (viewable.get() instanceof CarriedInventory) {
                Optional carrier = ((CarriedInventory)((Object)viewable.get())).carrier();
                if (carrier.get() instanceof AbstractHorse) {
                    player.openHorseInventory((AbstractHorse)carrier.get(), (net.minecraft.world.Container)viewable.get());
                }
            } else if (viewable.get() instanceof Merchant) {
                OptionalInt containerId;
                Merchant merchant = (Merchant)viewable.get();
                net.minecraft.network.chat.Component display = null;
                int level = 0;
                if (merchant instanceof Villager) {
                    display = ((Villager)merchant).getDisplayName();
                    level = ((Villager)merchant).getVillagerData().getLevel();
                } else if (merchant instanceof WanderingTrader) {
                    display = ((WanderingTrader)merchant).getDisplayName();
                    level = 1;
                }
                if (displayName != null) {
                    display = SpongeAdventure.asVanilla(displayName);
                }
                if ((containerId = player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInv, p) -> new MerchantMenu(id, playerInv, merchant), display))).isPresent() && !merchant.getOffers().isEmpty()) {
                    player.sendMerchantOffers(containerId.getAsInt(), merchant.getOffers(), level, merchant.getVillagerXp(), merchant.showProgressBar(), merchant.canRestock());
                }
            }
        }
        if (previousContainer == (container = player.containerMenu)) {
            return null;
        }
        if (!InventoryEventFactory.callInteractContainerOpenEvent(player)) {
            return null;
        }
        if (container instanceof ContainerBridge) {
            ((ContainerBridge)container).bridge$setCanInteractWith(p -> !p.removed);
        }
        return container;
    }

    public static TransferInventoryEvent.Pre callTransferPre(Inventory source, Inventory destination) {
        PhaseTracker.getCauseStackManager().pushCause(source);
        TransferInventoryEvent.Pre event = SpongeEventFactory.createTransferInventoryEventPre(PhaseTracker.getCauseStackManager().currentCause(), source, destination);
        SpongeCommon.post(event);
        PhaseTracker.getCauseStackManager().popCause();
        return event;
    }

    public static void callTransferPost(@Nullable TrackedInventoryBridge captureSource, @Nullable Inventory source, @Nullable Inventory destination, ItemStack sourceStack, SlotTransaction sourceSlotTransaction) {
        if (captureSource == null || source == null || destination == null || sourceSlotTransaction == null) {
            return;
        }
        PhaseTracker.getCauseStackManager().pushCause(source);
        List<SlotTransaction> slotTransactions = captureSource.bridge$getCapturedSlotTransactions();
        sourceStack = sourceStack.copy();
        sourceStack.setCount(1);
        ItemStackSnapshot transferredStack = ItemStackUtil.snapshotOf(sourceStack);
        Slot sourceSlot = sourceSlotTransaction.slot();
        Slot targetSlot = null;
        for (SlotTransaction transaction : slotTransactions) {
            if (transaction == sourceSlotTransaction) continue;
            targetSlot = transaction.slot();
            break;
        }
        TransferInventoryEvent.Post event = SpongeEventFactory.createTransferInventoryEventPost(PhaseTracker.getCauseStackManager().currentCause(), source, sourceSlot, destination, targetSlot, transferredStack);
        SpongeCommon.post(event);
        slotTransactions.clear();
        PhaseTracker.getCauseStackManager().popCause();
    }

    public static SlotTransaction captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, ItemStack originalStack) {
        if (captureIn == null || inv == null) {
            return null;
        }
        Optional<Slot> slot = inv.slot(index);
        if (slot.isPresent()) {
            SlotTransaction trans = new SlotTransaction(slot.get(), ItemStackUtil.snapshotOf(originalStack), ItemStackUtil.snapshotOf(slot.get().peek()));
            captureIn.bridge$getCapturedSlotTransactions().add(trans);
            return trans;
        }
        SpongeCommon.logger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
        return null;
    }

    public static ItemStack captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, Supplier<ItemStack> transaction) {
        if (captureIn == null || inv == null) {
            return transaction.get();
        }
        Optional<Slot> slot = inv.slot(index);
        if (!slot.isPresent()) {
            SpongeCommon.logger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
            return transaction.get();
        }
        ItemStackSnapshot original = ItemStackUtil.snapshotOf(slot.get().peek());
        ItemStack remaining = transaction.get();
        if (remaining.isEmpty()) {
            ItemStackSnapshot replacement = ItemStackUtil.snapshotOf(slot.get().peek());
            captureIn.bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot.get(), original, replacement));
        }
        return remaining;
    }

    public static UpdateAnvilEvent callUpdateAnvilEvent(AnvilMenu anvil, ItemStack slot1, ItemStack slot2, ItemStack result, String name, int levelCost, int materialCost) {
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), ItemStackUtil.snapshotOf(result));
        UpdateAnvilEventCost costs = new UpdateAnvilEventCost(levelCost, materialCost);
        UpdateAnvilEvent event = SpongeEventFactory.createUpdateAnvilEvent(PhaseTracker.getCauseStackManager().currentCause(), new Transaction<AnvilCost>(costs, costs), (Inventory)anvil, name, ItemStackUtil.snapshotOf(slot1), transaction, ItemStackUtil.snapshotOf(slot2));
        SpongeCommon.post(event);
        return event;
    }

    public static ChangeEntityEquipmentEvent callChangeEntityEquipmentEvent(LivingEntity entity, ItemStackSnapshot before, ItemStackSnapshot after, Slot slot) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(before, after);
            ChangeEntityEquipmentEvent event = after.isEmpty() ? SpongeEventFactory.createChangeEntityEquipmentEventBreak(frame.currentCause(), (Entity)entity, slot, transaction) : SpongeEventFactory.createChangeEntityEquipmentEvent(frame.currentCause(), (Entity)entity, slot, transaction);
            SpongeCommon.post(event);
            ChangeEntityEquipmentEvent changeEntityEquipmentEvent = event;
            return changeEntityEquipmentEvent;
        }
    }

    public static int callEnchantEventLevelRequirement(EnchantmentMenu container, int seed, int option, int power, ItemStack itemStack, int levelRequirement) {
        Container enchantContainer = ContainerUtil.fromNative((AbstractContainerMenu)container);
        Player viewer = (Player)enchantContainer.viewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.inventory.getCarried());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        EnchantItemEvent.CalculateLevelRequirement event = SpongeEventFactory.createEnchantItemEventCalculateLevelRequirement(PhaseTracker.getCauseStackManager().currentCause(), levelRequirement, levelRequirement, enchantContainer, cursorTrans, ItemStackUtil.snapshotOf(itemStack), option, power, seed);
        SpongeCommon.post(event);
        return event.levelRequirement();
    }

    public static List<EnchantmentInstance> callEnchantEventEnchantmentList(EnchantmentMenu container, int seed, ItemStack itemStack, int option, int level, List<EnchantmentInstance> list) {
        List<Enchantment> enchList = Collections.unmodifiableList(SpongeRandomEnchantmentListBuilder.fromNative(list));
        Container enchantContainer = ContainerUtil.fromNative((AbstractContainerMenu)container);
        Player viewer = (Player)enchantContainer.viewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.inventory.getCarried());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        EnchantItemEvent.CalculateEnchantment event = SpongeEventFactory.createEnchantItemEventCalculateEnchantment(PhaseTracker.getCauseStackManager().currentCause(), enchList, enchList, enchantContainer, cursorTrans, ItemStackUtil.snapshotOf(itemStack), level, option, seed);
        SpongeCommon.post(event);
        if (event.enchantments() != event.originalEnchantments()) {
            return SpongeRandomEnchantmentListBuilder.toNative(event.enchantments());
        }
        return list;
    }

    public static EnchantItemEvent.Post callEnchantEventEnchantPost(Player playerIn, EnchantmentMenu container, SlotTransaction enchantedItem, SlotTransaction lapisItem, int option, int seed) {
        Container enchantContainer = ContainerUtil.fromNative((AbstractContainerMenu)container);
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(playerIn.inventory.getCarried());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        ArrayList<SlotTransaction> slotTrans = new ArrayList<SlotTransaction>();
        slotTrans.add(lapisItem);
        slotTrans.add(enchantedItem);
        EnchantItemEvent.Post event = SpongeEventFactory.createEnchantItemEventPost(PhaseTracker.getCauseStackManager().currentCause(), enchantContainer, cursorTrans, enchantedItem.slot(), Optional.empty(), slotTrans, option, seed);
        SpongeCommon.post(event);
        PacketPhaseUtil.handleSlotRestore(playerIn, (AbstractContainerMenu)container, event.transactions(), event.isCancelled());
        PacketPhaseUtil.handleCursorRestore(playerIn, event.cursorTransaction());
        return event;
    }
}

